/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo.internal.utils;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.extension.siddhi.execution.geo.internal.exception.GeoLocationResolverException;

public class DatabaseUtils {
    private static final DatabaseUtils instance = new DatabaseUtils();
    private static final Log log = LogFactory.getLog(DatabaseUtils.class);
    private DataSource dataSource = null;
    private String dataSourceName;

    private DatabaseUtils() {
    }

    public static DatabaseUtils getInstance() {
        return instance;
    }

    public void initialize(String dataSourceName) throws GeoLocationResolverException {
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(DataSourceService.class).getBundleContext();
            ServiceReference serviceRef = bundleContext.getServiceReference(DataSourceService.class);
            if (serviceRef == null) {
                throw new GeoLocationResolverException("Cannot find the datasourceService '" + DataSourceService.class.getName() + "'");
            }
            DataSourceService dataSourceService = (DataSourceService)bundleContext.getService(serviceRef);
            this.dataSource = (HikariDataSource)dataSourceService.getDataSource(dataSourceName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lookup for datasource '" + dataSourceName + "' completed through DataSource Service lookup."));
            }
        }
        catch (DataSourceException e) {
            throw new GeoLocationResolverException("Cannot connect to the datasource '" + dataSourceName + "'", e);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        throw new SQLException("Data source is not configured properly.");
    }

    public void closeAllConnections(PreparedStatement preparedStatement, Connection connection, ResultSet resultSet) {
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        this.closeConnection(connection);
    }

    private void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                log.error((Object)"Couldn't close connection", (Throwable)e);
            }
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"Couldn't close ResultSet", (Throwable)e);
            }
        }
    }

    private void closeStatement(Statement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)"Couldn't close Statement", (Throwable)e);
            }
        }
    }
}

