/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo.internal.utils;

import java.util.regex.Pattern;

public class Utilities {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public static boolean isIpAddress(String ipAddress) {
        return IPV4_PATTERN.matcher(ipAddress).matches() || IPV6_STD_PATTERN.matcher(ipAddress).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(ipAddress).matches();
    }
}

