/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder;

import com.google.code.geocoder.GeoSearchableAddress;
import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.GeocoderRequestBuilder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderGeometry;
import com.google.code.geocoder.model.GeocoderLocationType;
import com.google.code.geocoder.model.GeocoderResult;
import com.google.code.geocoder.model.GeocoderStatus;
import com.google.code.geocoder.model.LatLng;
import java.io.IOException;
import java.util.List;

public class GeoAddressService
implements GeoSearchableAddress {
    private Geocoder geocoder;

    public GeoAddressService() {
    }

    public GeoAddressService(Geocoder geocoder) {
        this.geocoder = geocoder;
    }

    @Override
    public GeocoderResult getAddress(String address) throws IOException {
        GeocoderRequestBuilder buildQuery = this.buildQuery(address, null);
        GeocodeResponse geocode = this.geocoder.geocode(buildQuery.getGeocoderRequest());
        return this.findMostAccurateGeoCoderResult(geocode);
    }

    @Override
    public GeocoderResult getAddress(String address, String ccTLD) throws IOException {
        GeocoderRequestBuilder buildQuery = this.buildQuery(address, ccTLD);
        GeocodeResponse geocode = this.geocoder.geocode(buildQuery.getGeocoderRequest());
        return this.findMostAccurateGeoCoderResult(geocode);
    }

    private GeocoderRequestBuilder buildQuery(String address, String ccTLD) {
        GeocoderRequestBuilder geocoderRequestBuilder = new GeocoderRequestBuilder().setAddress(address);
        if (ccTLD != null && !ccTLD.trim().isEmpty()) {
            geocoderRequestBuilder.setRegion(ccTLD);
        }
        return geocoderRequestBuilder;
    }

    private GeocoderResult findMostAccurateGeoCoderResult(GeocodeResponse geocode) {
        List<GeocoderResult> geocodingResults;
        GeocoderResult geocodingResultMostAccurate = null;
        if (geocode != null && geocode.getStatus() == GeocoderStatus.OK && (geocodingResults = geocode.getResults()).size() != 0) {
            geocodingResultMostAccurate = geocodingResults.get(0);
            GeocoderLocationType locationType = this.getGeometryLocationType(geocodingResultMostAccurate);
            for (GeocoderResult geocoderResult : geocodingResults) {
                GeocoderLocationType newLocationType = this.getGeometryLocationType(geocoderResult);
                if (newLocationType.compareTo(locationType) <= 0) continue;
                locationType = newLocationType;
                geocodingResultMostAccurate = geocoderResult;
            }
        }
        return geocodingResultMostAccurate;
    }

    private GeocoderLocationType getGeometryLocationType(GeocoderResult geocoderResult) {
        GeocoderLocationType locationType = null;
        GeocoderGeometry geometry = geocoderResult.getGeometry();
        if (geometry != null && geometry.getLocationType() != null) {
            locationType = geometry.getLocationType();
        }
        return locationType;
    }

    @Override
    public LatLng getLatLngPointsByAddress(String address) throws IOException {
        GeocoderResult result = this.getAddress(address);
        if (result == null) {
            return null;
        }
        return result.getGeometry().getLocation();
    }
}

