/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="createFromJSON", namespace="map", description="Returns the map created with the key values pairs given in the JSONstring.", parameters={@Parameter(name="json.string", description="JSON as a string, which is used to create the map.", type={DataType.STRING}, optional=false)}, examples={@Example(description="returns a map with the keys \"symbol\", \"price\", \"volume\", and with the values \"IBM\", 200 and 100 respectively.", syntax="createFromJSON(\u201c{\u2018symbol' : 'IBM' , 'price' : 200, 'volume' : 100}\u201d)")}, returnAttributes={@ReturnAttribute(description="Will return a map", type={DataType.OBJECT})})
public class CreateFromJSONFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:create() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data instanceof String) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            JSONObject jsonObject = null;
            try {
                jsonObject = new JSONObject(data.toString());
            }
            catch (JSONException e) {
                throw new SiddhiAppRuntimeException("Cannot create JSON from '" + data.toString() + "' in create from json function", (Throwable)e);
            }
            return this.getMapFromJson(map, jsonObject);
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    private Map<Object, Object> getMapFromJson(Map<Object, Object> map, JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Map<Object, Object> value = null;
            try {
                value = jsonObject.get(key);
            }
            catch (JSONException e) {
                throw new SiddhiAppRuntimeException("JSON '" + jsonObject + "'does not contain key '" + key + "' in create from json function", (Throwable)e);
            }
            if (value instanceof JSONObject) {
                value = this.getMapFromJson(new HashMap<Object, Object>(), (JSONObject)((Object)value));
            }
            map.put(key, value);
        }
        return map;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> map) {
    }
}

