/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="createFromXML", namespace="map", description="Returns the map created with the key values pairs given in the XMLstring.", parameters={@Parameter(name="xml.string", description="XML as a string, which is used to create the map.", type={DataType.STRING}, optional=false)}, examples={@Example(description=" returns a map with the keys \"symbol\", \"price\", \"volume\", and with the values \"IBM\", 200 and 100 respectively.", syntax="createFromJSON(\u201c{\u2018symbol' : 'IBM' , 'price' : 200, 'volume' : 100}\u201d)")}, returnAttributes={@ReturnAttribute(description="will return a map", type={DataType.OBJECT})})
public class CreateFromXMLFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;
    private NumberFormat numberFormat = NumberFormat.getInstance();

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:createFromXML() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data instanceof String) {
            try {
                OMElement parentElement = AXIOMUtil.stringToOM(data.toString());
                return this.getMapFromXML(parentElement);
            }
            catch (XMLStreamException e) {
                throw new SiddhiAppRuntimeException("Input data cannot be parsed to xml: " + e.getMessage(), (Throwable)e);
            }
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    private Object getMapFromXML(OMElement parentElement) throws XMLStreamException {
        HashMap<String, Object> topLevelMap = new HashMap<String, Object>();
        Iterator iterator = parentElement.getChildElements();
        while (iterator.hasNext()) {
            Object value;
            OMElement streamAttributeElement = (OMElement)iterator.next();
            String key = streamAttributeElement.getQName().toString();
            if (streamAttributeElement.getFirstElement() != null) {
                value = this.getMapFromXML(streamAttributeElement);
            } else {
                String elementText = streamAttributeElement.getText();
                if (elementText.equals("true") || elementText.equals("false")) {
                    value = Boolean.parseBoolean(elementText);
                } else if (NumberUtils.isNumber(elementText)) {
                    try {
                        value = this.numberFormat.parse(elementText);
                    }
                    catch (ParseException e) {
                        value = elementText;
                    }
                } else {
                    value = elementText;
                }
            }
            topLevelMap.put(key, value);
        }
        return topLevelMap;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

