/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="get", namespace="map", description="Returns the value object from the map that is related to the given key.", parameters={@Parameter(name="map", description="Map where the value should return", type={DataType.OBJECT}, optional=false), @Parameter(name="key", description="Key of the value which needed to return", type={DataType.OBJECT}, optional=false)}, examples={@Example(description="returns the value that is related to the key 1 from the map named company.", syntax="get(company,1)")}, returnAttributes={@ReturnAttribute(description="Returns the value object from the map that is related to the given key", type={DataType.OBJECT})})
public class GetFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:get() function, required 2, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        if (!(data[0] instanceof Map)) {
            throw new SiddhiAppRuntimeException("First attribute value must be of type java.util.Map");
        }
        Map map = (Map)data[0];
        return map.get(data[1]);
    }

    protected Object execute(Object data) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

