/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="isMap", namespace="map", description="Returns true if the object is a map or false otherwise.t", parameters={@Parameter(name="object", description="Object that needed to check whether it is a map", type={DataType.OBJECT}, optional=false)}, examples={@Example(description="returns true if the students object is a map. It returns false if the students object is not a map.", syntax="isMap(students)")}, returnAttributes={@ReturnAttribute(description="Returns a boolean value", type={DataType.BOOL})})
public class IsMapFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.BOOL;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:isMap() function, required only one, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Boolean execute(Object data) {
        if (data instanceof Map) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

