/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="put", namespace="map", description="Returns the updated map after adding the given key-value pair", parameters={@Parameter(name="map", description="Map that value should add", type={DataType.OBJECT}, optional=false), @Parameter(name="key", description="Key of the value", type={DataType.OBJECT}, optional=false), @Parameter(name="value", description="New value", type={DataType.OBJECT}, optional=false)}, examples={@Example(description=" returns the updated map named students after adding the object \"sam\" with key 1234.", syntax="put(students , 1234 , \u201dsam\u201d)")}, returnAttributes={@ReturnAttribute(description="A hashMap will be return", type={DataType.OBJECT})})
public class PutFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 3) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:put() function, required 3 parameters, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        if (data == null) {
            throw new SiddhiAppRuntimeException("Data can not be null.");
        }
        Map hashMap = (Map)data[0];
        hashMap.put(data[1], data[2]);
        return hashMap;
    }

    protected Object execute(Object data) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

