/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="remove", namespace="map", description="Returns the updated map after removing the element with key.", parameters={@Parameter(name="map", description="Map that needed to remove the element", type={DataType.OBJECT}, optional=false), @Parameter(name="key", description="key of the element the needed to remove", type={DataType.OBJECT}, optional=false)}, examples={@Example(description="returns the updated map students after removing the element with the key 1234", syntax="remove(students , 1234)")}, returnAttributes={@ReturnAttribute(description="return Object will be a HashMap", type={DataType.OBJECT})})
public class RemoveFunctionExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(RemoveFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length < 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:remove() function, required one or more keys, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        Map map = (Map)data[0];
        for (int i = 1; i < data.length; ++i) {
            map.remove(data[i]);
        }
        return map;
    }

    protected Object execute(Object data) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

