/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.Map;
import org.json.JSONObject;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="toJSON", namespace="map", description="Converts a map into a JSON object and returns the definition of that JSON object as a string.", parameters={@Parameter(name="map", description="map that nedded to be converted to JSON", type={DataType.OBJECT}, optional=false)}, examples={@Example(description="If \"company\" is a map with key value pairs (\"symbol\" : wso2),(\"volume\" : 100), and (\"price\",200). This will returns the string \u201c{\u201csymbol\u201d : \u201cwso2\u201d , \u201cvolume\u201d : 100 , \u201cprice\u201d : 200}\u201d.", syntax="toJSON(company")}, returnAttributes={@ReturnAttribute(description="Returns a string representation of the map in JSON format", type={DataType.STRING})})
public class ToJSONFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:toJSON() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            JSONObject jsonObject = new JSONObject(map);
            return jsonObject.toString();
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

