/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.map;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="toXML", namespace="map", description="Returns the map as an XML string.", parameters={@Parameter(name="map", description="map that needed to convert to XML", type={DataType.OBJECT}, optional=false), @Parameter(name="rootelementname", description="root element of the map", type={DataType.OBJECT}, optional=true, defaultValue="null")}, examples={@Example(description="If \"company\" is a map with key value pairs (\u201csymbol\u201d : wso2), (\u201cvolume\u201d : 100), and (\u201cprice\u201d : 200). this will  returns the string \u201c<abcCompany><symbol>wso2</symbol><volume><100></volume><price>200</price></abcCompany>", syntax="toXML(company, \"abcCompany\")")}, returnAttributes={@ReturnAttribute(description="returns the string representation of the map in XML format", type={DataType.STRING})})
public class ToXMLFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;
    private String rootElement = null;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length > 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:toXML() function, required only 1 or 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors.length == 2) {
            Object rootElementObject = attributeExpressionExecutors[1].execute(null);
            if (rootElementObject instanceof String) {
                this.rootElement = (String)rootElementObject;
            } else {
                throw new OperationNotSupportedException("Root element name should be of type String. But found " + attributeExpressionExecutors[1].getReturnType());
            }
        }
    }

    protected Object execute(Object[] data) {
        if (data[0] instanceof Map) {
            Map map = (Map)data[0];
            return this.getXmlFromMapWithRootElement(map);
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    protected Object execute(Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            return this.getXmlFromMap(map);
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    private Object getXmlFromMap(Map<Object, Object> map) {
        return this.addingElements(map);
    }

    private Object getXmlFromMapWithRootElement(Map<Object, Object> map) {
        StringBuilder xmlValue = new StringBuilder();
        xmlValue.append("<" + this.rootElement + ">");
        xmlValue.append(this.addingElements(map));
        xmlValue.append("</" + this.rootElement + ">");
        return xmlValue.toString();
    }

    private String addingElements(Map<Object, Object> map) {
        StringBuilder xmlValue = new StringBuilder();
        for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
            xmlValue.append("<" + mapEntry.getKey().toString() + ">");
            if (mapEntry.getValue() instanceof Map) {
                xmlValue.append(this.getXmlFromMap((Map)mapEntry.getValue()));
            } else {
                xmlValue.append(mapEntry.getValue().toString());
            }
            xmlValue.append("</" + mapEntry.getKey().toString() + ">");
        }
        return xmlValue.toString();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

