/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.callback;

import javax.jms.JMSException;
import javax.jms.Session;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

public abstract class JMSCallback
implements CarbonCallback {
    private Session session;
    private final Object caller;
    private boolean operationComplete = false;

    public JMSCallback(Session session, Object caller) {
        this.session = session;
        this.caller = caller;
    }

    public boolean isOperationComplete() {
        return this.operationComplete;
    }

    protected void commitSession() throws JMSConnectorException {
        try {
            this.session.commit();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while committing the session.");
        }
    }

    protected void rollbackSession() throws JMSConnectorException {
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while rolling back the session.", e);
        }
    }

    protected void recoverSession() throws JMSConnectorException {
        try {
            this.session.recover();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while recovering the JMS session", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAsComplete() {
        this.operationComplete = true;
        Object object = this.caller;
        synchronized (object) {
            this.caller.notifyAll();
        }
    }
}

