/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.PooledConnectionKey;

public class PooledJMSConnectionFactory
extends JMSConnectionFactory
implements KeyedPooledObjectFactory<PooledConnectionKey, Connection> {
    private static final Logger log = LoggerFactory.getLogger(PooledJMSConnectionFactory.class);
    private GenericKeyedObjectPool<PooledConnectionKey, Connection> keyedObjectPool = new GenericKeyedObjectPool<PooledConnectionKey, Connection>(this);
    private ConcurrentHashMap<Connection, PooledConnectionKey> connectionKeyMap = new ConcurrentHashMap();

    public PooledJMSConnectionFactory(Properties properties) throws JMSConnectorException {
        super(properties);
        Object maxConcurrentConnections = properties.get("maxConnections");
        if (maxConcurrentConnections != null) {
            this.keyedObjectPool.setMaxTotal(Integer.parseInt((String)maxConcurrentConnections));
        }
    }

    @Override
    public Connection createConnection() throws JMSException {
        PooledConnectionKey key = new PooledConnectionKey(null, null);
        try {
            Connection connection = this.keyedObjectPool.borrowObject(key);
            if (!this.validateObject(key, (PooledObject<Connection>)new DefaultPooledObject<Connection>(connection))) {
                this.keyedObjectPool.invalidateObject(key, connection);
                throw new JMSException("Could not create a valid connection");
            }
            return connection;
        }
        catch (Exception e) {
            throw new JMSException("Error occurred creating connection : " + e.getMessage());
        }
    }

    @Override
    public Connection createConnection(String userName, String password) throws JMSException {
        PooledConnectionKey key = new PooledConnectionKey(userName, password);
        try {
            return this.keyedObjectPool.borrowObject(key);
        }
        catch (Exception e) {
            throw new JMSException("Error occurred creating connection : " + e.getMessage());
        }
    }

    @Override
    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    @Override
    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    @Override
    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    @Override
    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    @Override
    public void closeConnection(Connection connection) throws JMSConnectorException {
        PooledConnectionKey key = this.connectionKeyMap.get(connection);
        if (key != null) {
            try {
                this.keyedObjectPool.returnObject(key, connection);
            }
            catch (Exception e) {
                throw new JMSConnectorException("Failed to return the connection back to the pool", e);
            }
        }
    }

    @Override
    public PooledObject<Connection> makeObject(PooledConnectionKey key) throws Exception {
        String username = key.getUsername();
        String password = key.getPassword();
        Connection connection = username == null && password == null ? super.createConnection() : super.createConnection(key.getUsername(), key.getPassword());
        this.connectionKeyMap.put(connection, key);
        return new DefaultPooledObject<Connection>(connection);
    }

    @Override
    public void destroyObject(PooledConnectionKey key, PooledObject<Connection> pooledConnectionObject) throws Exception {
        Connection connection = pooledConnectionObject.getObject();
        this.connectionKeyMap.remove(connection);
        connection.close();
    }

    @Override
    public boolean validateObject(PooledConnectionKey key, PooledObject<Connection> pooledConnectionObject) {
        boolean valid = false;
        try {
            Session session = pooledConnectionObject.getObject().createSession(false, 1);
            session.close();
            valid = true;
        }
        catch (JMSException e) {
            log.warn("Connection with key " + key.hashCode() + " is not valid anymore");
        }
        return valid;
    }

    @Override
    public void activateObject(PooledConnectionKey key, PooledObject<Connection> pooledConnectionObject) throws Exception {
        pooledConnectionObject.getObject().start();
    }

    @Override
    public void passivateObject(PooledConnectionKey key, PooledObject<Connection> pooledConnectionObject) throws Exception {
        pooledConnectionObject.getObject().stop();
    }
}

