/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.utils;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.SerializableCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

public class JMSUtils {
    public static Destination lookupDestination(Context context, String destinationName, String destinationType) throws NamingException {
        if (null == destinationName) {
            return null;
        }
        return JMSUtils.lookup(context, Destination.class, destinationName);
    }

    private static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            if (object instanceof Reference) {
                Reference ref = (Reference)object;
                String errorMessage = "JNDI failed to de-reference Reference with name " + name + "; is the factory " + ref.getFactoryClassName() + " in your classpath?";
                throw new NamingException(errorMessage);
            }
            String errorMessage = "JNDI lookup of name " + name + " returned a " + object.getClass().getName() + " while a " + clazz + " was expected";
            throw new NamingException(errorMessage);
        }
    }

    public static CarbonMessage createJMSCarbonMessage(Message message) throws JMSConnectorException {
        try {
            TextCarbonMessage jmsCarbonMessage;
            if (message instanceof TextMessage) {
                jmsCarbonMessage = new TextCarbonMessage(((TextMessage)message).getText());
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"TextMessage");
            } else if (message instanceof MapMessage) {
                MapCarbonMessage mapCarbonMessage = new MapCarbonMessage();
                MapMessage mapMessage = (MapMessage)message;
                Enumeration mapKeys = ((MapMessage)message).getMapNames();
                while (mapKeys.hasMoreElements()) {
                    String mapKey = (String)mapKeys.nextElement();
                    String mapValue = mapMessage.getString(mapKey);
                    if (null == mapValue) continue;
                    mapCarbonMessage.setValue(mapKey, mapValue);
                }
                jmsCarbonMessage = mapCarbonMessage;
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"MapMessage");
            } else if (message instanceof ObjectMessage) {
                try {
                    if (((ObjectMessage)message).getObject() instanceof SerializableCarbonMessage) {
                        jmsCarbonMessage = (SerializableCarbonMessage)((ObjectMessage)message).getObject();
                    } else {
                        SerializableCarbonMessage serializableCarbonMessage = new SerializableCarbonMessage();
                        serializableCarbonMessage.setPayload(((ObjectMessage)message).getObject().toString());
                        jmsCarbonMessage = serializableCarbonMessage;
                    }
                }
                catch (MessageFormatException e) {
                    jmsCarbonMessage = new SerializableCarbonMessage();
                }
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"ObjectMessage");
            } else {
                BytesMessage bytesMessage = (BytesMessage)message;
                String body = bytesMessage.getBodyLength() > 0L ? bytesMessage.readUTF() : "";
                jmsCarbonMessage = new TextCarbonMessage(body);
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"BytesMessage");
            }
            String messageId = message.getJMSMessageID();
            if (null != messageId) {
                jmsCarbonMessage.setHeader("JMS_MESSAGE_ID", messageId);
            }
            jmsCarbonMessage.setHeader("JMS_TYPE", message.getJMSType());
            jmsCarbonMessage.setHeader("JMS_DELIVERY_MODE", String.valueOf(message.getJMSDeliveryMode()));
            jmsCarbonMessage.setHeader("JMS_PRIORITY", String.valueOf(message.getJMSPriority()));
            jmsCarbonMessage.setHeader("JMS_REDELIVERED", String.valueOf(message.getJMSRedelivered()));
            jmsCarbonMessage.setHeader("JMS_TIMESTAMP", String.valueOf(message.getJMSTimestamp()));
            jmsCarbonMessage.setHeader("JMS_EXPIRATION", String.valueOf(message.getJMSExpiration()));
            jmsCarbonMessage.setHeader("JMS_CORRELATION_ID", message.getJMSCorrelationID());
            jmsCarbonMessage.setHeader("JMS_DESTINATION", JMSUtils.getDestinationName(message.getJMSDestination()));
            if (message.getJMSReplyTo() != null) {
                jmsCarbonMessage.setHeader("JMS_REPLY_TO", JMSUtils.getDestinationName(message.getJMSReplyTo()));
            }
            Enumeration propertyNames = message.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                jmsCarbonMessage.setProperty(name, (Object)message.getStringProperty(name));
            }
            return jmsCarbonMessage;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while changing the jms message to carbon message", e);
        }
    }

    private static String getDestinationName(Destination jmsDestination) throws JMSConnectorException {
        try {
            String destinationAsString;
            if (jmsDestination instanceof Queue) {
                destinationAsString = ((Queue)jmsDestination).getQueueName();
            } else if (jmsDestination instanceof Topic) {
                destinationAsString = ((Topic)jmsDestination).getTopicName();
            } else {
                throw new JMSConnectorException("Unknown JMS destination type. [ " + jmsDestination + " ]");
            }
            return destinationAsString;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error occurred while retrieving the destination name for JMS Destination [ " + jmsDestination + " ]", e);
        }
    }
}

