/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.callback;

import javax.jms.Session;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.transport.jms.callback.JMSCallback;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

public class TransactedSessionCallback
extends JMSCallback {
    public TransactedSessionCallback(Session session, Object caller) {
        super(session, caller);
    }

    public void done(CarbonMessage carbonMessage) {
        try {
            if (carbonMessage.getProperty("JMS_MESSAGE_DELIVERY_STATUS").equals("SUCCESS")) {
                this.commitSession();
            } else {
                this.rollbackSession();
            }
        }
        catch (JMSConnectorException e) {
            throw new RuntimeException("Error completing the transaction callback operation", (Throwable)((Object)e));
        }
        finally {
            this.markAsComplete();
        }
    }
}

