/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.receiver.JMSMessageHandler;

public class JMSMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(JMSMessageListener.class);
    private CarbonMessageProcessor carbonMessageProcessor;
    private String serviceId;
    private int acknowledgementMode;
    private Session session;
    private JMSMessageHandler messageHandler;

    JMSMessageListener(CarbonMessageProcessor messageProcessor, String serviceId, Session session) throws JMSConnectorException {
        this.carbonMessageProcessor = messageProcessor;
        this.serviceId = serviceId;
        this.session = session;
        this.messageHandler = new JMSMessageHandler(this.carbonMessageProcessor, serviceId, session);
    }

    public void onMessage(Message message) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Message Received. MessageId : " + message.getJMSMessageID());
            }
            this.messageHandler.handle(message);
        }
        catch (JMSConnectorException e) {
            throw new RuntimeException("An error occurred while listening to messages", (Throwable)((Object)e));
        }
        catch (JMSException e) {
            throw new RuntimeException("Error retrieving messageId from the received message", e);
        }
    }
}

