/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.jms.sink;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.messaging.exceptions.ClientConnectorException;
import org.wso2.carbon.transport.jms.sender.JMSClientConnector;

public class JMSPublisher
implements Runnable {
    private static final Logger log = Logger.getLogger(JMSPublisher.class);
    private static final String MESSAGE_TYPE_FIELD = "JMS_MESSAGE_TYPE";
    private static final String TEXT_MESSAGE_TYPE = "TextMessage";
    private static final String BYTE_ARRAY_MESSAGE_TYPE = "ByteMessage";
    private Map<String, String> jmsProperties = new HashMap<String, String>();
    private JMSClientConnector jmsClientConnector;
    private CarbonMessage message;

    public JMSPublisher(String destination, Map<String, String> staticJMSProperties, JMSClientConnector jmsClientConnector, Object payload) throws UnsupportedEncodingException {
        this.jmsProperties.putAll(staticJMSProperties);
        this.jmsProperties.put("transport.jms.Destination", destination);
        this.jmsClientConnector = jmsClientConnector;
        this.message = this.handleCarbonMessage(payload);
    }

    @Override
    public void run() {
        try {
            this.jmsClientConnector.send(this.message, null, this.jmsProperties);
        }
        catch (ClientConnectorException e) {
            log.error((Object)"Error sending JMS message: ", (Throwable)e);
        }
    }

    private CarbonMessage handleCarbonMessage(Object payload) throws UnsupportedEncodingException {
        if (payload instanceof String) {
            TextCarbonMessage textCarbonMessage = new TextCarbonMessage(payload.toString());
            this.jmsProperties.put(MESSAGE_TYPE_FIELD, TEXT_MESSAGE_TYPE);
            return textCarbonMessage;
        }
        if (payload instanceof Map) {
            MapCarbonMessage mapCarbonMessage = new MapCarbonMessage();
            ((Map)payload).forEach((key, value) -> mapCarbonMessage.setValue((String)key, String.valueOf(value)));
            return mapCarbonMessage;
        }
        if (payload instanceof ByteBuffer) {
            byte[] data = ((ByteBuffer)payload).array();
            String text = new String(data, "UTF-8");
            TextCarbonMessage byteCarbonMessage = new TextCarbonMessage(text);
            this.jmsProperties.put(MESSAGE_TYPE_FIELD, BYTE_ARRAY_MESSAGE_TYPE);
            log.info((Object)byteCarbonMessage.getMessageBody());
            return byteCarbonMessage;
        }
        throw new UnsupportedEncodingException("The type of the output payload cannot be cast to String, Map or Byte[] from JMS");
    }
}

