/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.utils.JMSConstants;
import org.wso2.carbon.transport.jms.utils.JMSUtils;

public class JMSConnectionResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(JMSConnectionResourceFactory.class);
    private Context ctx;
    private ConnectionFactory connectionFactory;
    private XAConnectionFactory xAConnectionFactory;
    private String connectionFactoryString;
    protected JMSConstants.JMSDestinationType destinationType;
    private boolean transactedSession = false;
    private boolean xATransacted = false;
    private int sessionAckMode = 1;
    protected String jmsSpec;
    protected String clientId;
    private Properties properties;
    private String username;
    private String password;

    public JMSConnectionResourceFactory(Properties properties) throws JMSConnectorException {
        String strSessionAck;
        this.properties = properties;
        try {
            this.ctx = new InitialContext(properties);
        }
        catch (NamingException e) {
            throw new JMSConnectorException("NamingException while obtaining initial context. ", e);
        }
        String connectionFactoryType = properties.getProperty("transport.jms.ConnectionFactoryType");
        this.destinationType = "topic".equalsIgnoreCase(connectionFactoryType) ? JMSConstants.JMSDestinationType.TOPIC : JMSConstants.JMSDestinationType.QUEUE;
        String jmsSpecVersion = properties.getProperty("transport.jms.JMSSpecVersion");
        if (null == jmsSpecVersion) {
            this.jmsSpec = "1.1";
        } else {
            switch (jmsSpecVersion) {
                case "1.1": {
                    this.jmsSpec = "1.1";
                    break;
                }
                case "2.0": {
                    this.jmsSpec = "2.0";
                    break;
                }
                case "1.0": {
                    this.jmsSpec = "1.0";
                    break;
                }
                default: {
                    this.jmsSpec = "1.1";
                }
            }
        }
        this.clientId = properties.getProperty("transport.jms.DurableSubscriberClientId");
        this.connectionFactoryString = properties.getProperty("transport.jms.ConnectionFactoryJNDIName");
        if (null == this.connectionFactoryString || "".equals(this.connectionFactoryString)) {
            this.connectionFactoryString = "QueueConnectionFactory";
        }
        if (null == (strSessionAck = properties.getProperty("transport.jms.SessionAcknowledgement"))) {
            this.sessionAckMode = 1;
        } else if (strSessionAck.equals("CLIENT_ACKNOWLEDGE")) {
            this.sessionAckMode = 2;
        } else if (strSessionAck.equals("DUPS_OK_ACKNOWLEDGE")) {
            this.sessionAckMode = 3;
        } else if (strSessionAck.equals("SESSION_TRANSACTED")) {
            this.sessionAckMode = 0;
            this.transactedSession = true;
        } else if (strSessionAck.equals("XA_TRANSACTED")) {
            this.sessionAckMode = -1;
            this.xATransacted = true;
        }
        this.username = properties.getProperty("connectionUsername");
        this.password = properties.getProperty("connectionPassword");
        this.createConnectionFactory();
    }

    public ConnectionFactory getConnectionFactory() throws JMSConnectorException {
        if (this.connectionFactory == null) {
            this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    private void createConnectionFactory() throws JMSConnectorException {
        try {
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                if (this.isxATransacted()) {
                    this.xAConnectionFactory = (XAConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
                } else {
                    this.connectionFactory = (ConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
                }
            } else if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                if (this.isxATransacted()) {
                    this.xAConnectionFactory = (XAQueueConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
                } else {
                    this.connectionFactory = (QueueConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
                }
            } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                if (this.isxATransacted()) {
                    this.xAConnectionFactory = (XATopicConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
                } else {
                    this.connectionFactory = (TopicConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
                }
            }
        }
        catch (NamingException e) {
            throw new JMSConnectorException("Naming exception while obtaining connection factory for " + this.connectionFactoryString, e);
        }
    }

    public Connection createConnection() throws JMSException {
        if (null == this.connectionFactory) {
            throw new JMSException("Connection cannot be establish to the broker. Connection Factory is null. Please check the Please check the broker libs provided.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a new JMS Connection on: " + this.connectionFactoryString);
        }
        if (this.username != null && this.password != null) {
            return this.createConnection(this.username, this.password);
        }
        if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
            return this.connectionFactory.createConnection();
        }
        QueueConnectionFactory qConFac = null;
        TopicConnectionFactory tConFac = null;
        if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
            qConFac = (QueueConnectionFactory)this.connectionFactory;
        } else {
            tConFac = (TopicConnectionFactory)this.connectionFactory;
        }
        if (null != qConFac) {
            return qConFac.createQueueConnection();
        }
        return tConFac.createTopicConnection();
    }

    private Connection createConnection(String userName, String password) throws JMSException {
        if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
            return this.connectionFactory.createConnection(userName, password);
        }
        QueueConnectionFactory qConFac = null;
        TopicConnectionFactory tConFac = null;
        if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
            qConFac = (QueueConnectionFactory)this.connectionFactory;
        } else {
            tConFac = (TopicConnectionFactory)this.connectionFactory;
        }
        if (null != qConFac) {
            return qConFac.createQueueConnection(userName, password);
        }
        return tConFac.createTopicConnection(userName, password);
    }

    public XAConnection createXAConnection() throws JMSException {
        if (null == this.xAConnectionFactory) {
            throw new JMSException("XAConnection cannot be establish to the broker. XAConnection Factory is null. Please check the Please check the broker libs provided.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a new JMS XAConnection on: " + this.connectionFactoryString);
        }
        if (this.username != null && this.password != null) {
            return this.createXAConnection(this.username, this.password);
        }
        if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
            return this.xAConnectionFactory.createXAConnection();
        }
        XAQueueConnectionFactory qConFac = null;
        XATopicConnectionFactory tConFac = null;
        if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
            qConFac = (XAQueueConnectionFactory)this.xAConnectionFactory;
        } else {
            tConFac = (XATopicConnectionFactory)this.xAConnectionFactory;
        }
        if (null != qConFac) {
            return qConFac.createXAQueueConnection();
        }
        return tConFac.createXATopicConnection();
    }

    private XAConnection createXAConnection(String userName, String password) throws JMSException {
        if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
            return this.xAConnectionFactory.createXAConnection(userName, password);
        }
        XAQueueConnectionFactory qConFac = null;
        XATopicConnectionFactory tConFac = null;
        if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
            qConFac = (XAQueueConnectionFactory)this.xAConnectionFactory;
        } else {
            tConFac = (XATopicConnectionFactory)this.xAConnectionFactory;
        }
        if (null != qConFac) {
            return qConFac.createXAQueueConnection(userName, password);
        }
        return tConFac.createXATopicConnection(userName, password);
    }

    public Destination createDestination(Session session, String destinationName) throws JMSConnectorException {
        Destination destination = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Creating a new JMS Destination on: " + this.connectionFactoryString);
        }
        try {
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                destination = JMSUtils.lookupDestination(this.ctx, destinationName, "queue");
            } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                destination = JMSUtils.lookupDestination(this.ctx, destinationName, "topic");
            }
        }
        catch (NameNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not find destination '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'. " + e.getMessage());
                logger.debug("Creating destination '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + ".");
            }
            try {
                if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                    destination = session.createQueue(destinationName);
                } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                    destination = session.createTopic(destinationName);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Created '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'.");
                }
            }
            catch (JMSException e1) {
                throw new JMSConnectorException("Could not find nor create '" + destinationName + "' on connection factory for " + this.connectionFactoryString, e1);
            }
        }
        catch (NamingException e) {
            throw new JMSConnectorException("Naming exception while looking up for the destination name " + destinationName, e);
        }
        return destination;
    }

    public Session createSession(Connection connection) throws JMSConnectorException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating a new JMS Session on: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                return connection.createSession(this.transactedSession, this.sessionAckMode);
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((QueueConnection)connection).createQueueSession(this.transactedSession, this.sessionAckMode);
            }
            return ((TopicConnection)connection).createTopicSession(this.transactedSession, this.sessionAckMode);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while obtaining session for factory " + this.connectionFactoryString, e);
        }
    }

    public XASession createXASession(XAConnection xAConnection) throws JMSConnectorException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating a new JMS XASession on: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                return xAConnection.createXASession();
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((XAQueueConnection)xAConnection).createXAQueueSession();
            }
            return ((XATopicConnection)xAConnection).createXATopicSession();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while obtaining session for factory " + this.connectionFactoryString, e);
        }
    }

    public MessageProducer createMessageProducer(Session session) throws JMSConnectorException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Creating a new JMS Message Producer on: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                return session.createProducer(null);
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((QueueSession)session).createSender(null);
            }
            return ((TopicSession)session).createPublisher(null);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while creating the producer for the destination ", e);
        }
    }

    public boolean isTransactedSession() {
        return this.transactedSession;
    }

    public boolean isxATransacted() {
        return this.xATransacted;
    }

    public int getSessionAckMode() {
        return this.sessionAckMode;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void notifyError(JMSException ex) {
    }

    public String getJmsSpec() {
        return this.jmsSpec;
    }

    public JMSConstants.JMSDestinationType getDestinationType() {
        return this.destinationType;
    }

    public void closeConnection(Connection connection) throws JMSException {
        if (connection != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing a JMS Connection of: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                connection.close();
            } else if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                ((QueueConnection)connection).close();
            } else {
                ((TopicConnection)connection).close();
            }
        }
    }

    public void closeSession(Session session) throws JMSException {
        if (session != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing a JMS Session of: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                session.close();
            } else if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                ((QueueSession)session).close();
            } else {
                ((TopicSession)session).close();
            }
        }
    }

    public void closeProducer(MessageProducer messageProducer) throws JMSException {
        if (messageProducer != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing a JMS Message Producer of: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                messageProducer.close();
            } else if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                ((QueueSender)messageProducer).close();
            } else {
                ((TopicPublisher)messageProducer).close();
            }
        }
    }

    public void closeConsumer(MessageConsumer messageConsumer) throws JMSException {
        if (messageConsumer != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing a JMS Message Consumer of: " + this.connectionFactoryString);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                messageConsumer.close();
            } else if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                if (messageConsumer instanceof QueueReceiver) {
                    ((QueueReceiver)messageConsumer).close();
                }
            } else if (messageConsumer instanceof TopicSubscriber) {
                ((TopicSubscriber)messageConsumer).close();
            }
        }
    }

    public void start(Connection connection) throws JMSConnectorException, JMSSecurityException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a JMS Connection of: " + this.connectionFactoryString);
            }
            connection.start();
        }
        catch (JMSSecurityException e) {
            throw e;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while starting connection for factory " + this.connectionFactoryString, e);
        }
    }

    public void stop(Connection connection) throws JMSConnectorException {
        try {
            if (null != connection) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Stopping a JMS Connection of: " + this.connectionFactoryString);
                }
                connection.stop();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while stopping the connection for factory " + this.connectionFactoryString, e);
        }
    }

    protected String getConnectionFactoryString() {
        return this.connectionFactoryString;
    }
}

