/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                boolean success = FileUtils.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("Source file does not exist: " + source);
        }
        try {
            Files.createDirectories(destination.toPath(), new FileAttribute[0]);
            Files.copy(source.toPath(), destination.toPath().resolve(source.getName()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.warn("Unable to copy file " + e.getMessage(), (Throwable)e);
            throw new IOException("Unable to copy file ", e);
        }
    }

    public static void copyFileToDir(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("Source file does not exist: " + source);
        }
        try {
            Files.createDirectories(destination.toPath(), new FileAttribute[0]);
            Files.copy(source.toPath(), destination.toPath().resolve(source.getName()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.warn("Unable to copy file " + e.getMessage(), (Throwable)e);
            throw new IOException("Unable to copy file ", e);
        }
    }
}

