/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.sender;

import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.TopicPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.contract.JMSClientConnector;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.JMSClientConnectionFactory;
import org.wso2.carbon.transport.jms.sender.JMSConnectionFactoryManager;
import org.wso2.carbon.transport.jms.sender.wrappers.SessionWrapper;
import org.wso2.carbon.transport.jms.utils.JMSConstants;

public class JMSClientConnectorImpl
implements JMSClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSClientConnectorImpl.class);
    private JMSClientConnectionFactory jmsConnectionFactory;

    public JMSClientConnectorImpl(Map<String, String> propertyMap) throws JMSConnectorException {
        try {
            Properties properties = new Properties();
            properties.putAll(propertyMap);
            this.jmsConnectionFactory = JMSConnectionFactoryManager.getInstance().getJMSConnectionFactory(properties);
        }
        catch (JMSConnectorException e) {
            throw new JMSConnectorException("Error connecting to JMS provider. " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean send(Message jmsMessage, String destinationName) throws JMSConnectorException {
        SessionWrapper sessionWrapper;
        block7: {
            sessionWrapper = null;
            if (this.jmsConnectionFactory.isClientCaching()) break block7;
            this.sendNonCached(jmsMessage, destinationName);
            boolean bl = true;
            if (sessionWrapper == null) return bl;
            this.jmsConnectionFactory.returnSessionWrapper(sessionWrapper);
            return bl;
        }
        try {
            sessionWrapper = this.jmsConnectionFactory.getSessionWrapper();
            Destination destination = this.jmsConnectionFactory.createDestination(sessionWrapper.getSession(), destinationName);
            this.sendJMSMessage(destination, jmsMessage, sessionWrapper.getMessageProducer());
            if (sessionWrapper == null) return true;
        }
        catch (JMSConnectorException e) {
            try {
                throw e;
                catch (JMSException e2) {
                    throw new JMSConnectorException("JMS Send Failed with [ " + e2.getMessage() + " ]", e2);
                }
                catch (Exception e3) {
                    throw new JMSConnectorException("Error getting the session. " + e3.getMessage(), e3);
                }
            }
            catch (Throwable throwable) {
                if (sessionWrapper == null) throw throwable;
                this.jmsConnectionFactory.returnSessionWrapper(sessionWrapper);
                throw throwable;
            }
        }
        this.jmsConnectionFactory.returnSessionWrapper(sessionWrapper);
        return true;
    }

    @Override
    public boolean sendTransactedMessage(Message jmsMessage, String destinationName, SessionWrapper sessionWrapper) throws JMSConnectorException {
        try {
            Destination destination = this.jmsConnectionFactory.createDestination(sessionWrapper.getSession(), destinationName);
            this.sendJMSMessage(destination, jmsMessage, sessionWrapper.getMessageProducer());
        }
        catch (JMSConnectorException e) {
            throw e;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Send Failed with [" + e.getMessage() + " ]", e);
        }
        catch (Exception e) {
            throw new JMSConnectorException("Error acquiring the session. " + e.getMessage(), e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Message createMessage(String messageType) throws JMSConnectorException {
        Message jmsMessage;
        if (this.jmsConnectionFactory.isClientCaching()) {
            SessionWrapper sessionWrapper = null;
            try {
                sessionWrapper = this.jmsConnectionFactory.getSessionWrapper();
                jmsMessage = this.createJMSMessage(sessionWrapper.getSession(), messageType);
                return jmsMessage;
            }
            catch (JMSException e) {
                throw new JMSConnectorException("Error creating the JMS Message. " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new JMSConnectorException("Error acquiring the session JMS Message. " + e.getMessage(), e);
            }
            finally {
                if (sessionWrapper != null) {
                    this.jmsConnectionFactory.returnSessionWrapper(sessionWrapper);
                }
            }
        }
        Connection connection = null;
        Session session = null;
        try {
            connection = this.jmsConnectionFactory.createConnection();
            session = this.jmsConnectionFactory.createSession(connection);
            jmsMessage = this.createJMSMessage(session, messageType);
        }
        catch (JMSException e) {
            try {
                throw new JMSConnectorException("Error creating the JMS Message. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                try {
                    this.jmsConnectionFactory.closeSession(session);
                    this.jmsConnectionFactory.closeConnection(connection);
                    throw throwable;
                }
                catch (JMSException e2) {
                    throw new JMSConnectorException("Error releasing the JMS resources. " + e2.getMessage(), e2);
                }
            }
        }
        try {
            this.jmsConnectionFactory.closeSession(session);
            this.jmsConnectionFactory.closeConnection(connection);
            return jmsMessage;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error releasing the JMS resources. " + e.getMessage(), e);
        }
    }

    @Override
    public SessionWrapper acquireSession() throws JMSConnectorException {
        SessionWrapper sessionWrapper;
        try {
            sessionWrapper = this.jmsConnectionFactory.getSessionWrapper();
        }
        catch (Exception e) {
            throw new JMSConnectorException("Error when acquiring the session. ", e);
        }
        return sessionWrapper;
    }

    @Override
    public void releaseSession(SessionWrapper sessionWrapper) throws JMSConnectorException {
        this.jmsConnectionFactory.returnSessionWrapper(sessionWrapper);
    }

    @Override
    public void closeConnectionFactory() throws JMSConnectorException {
        this.jmsConnectionFactory.closeJMSResources();
    }

    private void sendJMSMessage(Destination destination, Message message, MessageProducer producer) throws JMSException {
        if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.jmsConnectionFactory.getDestinationType()) || !"1.0".equals(this.jmsConnectionFactory.getJmsSpec())) {
            producer.send(destination, message, message.getJMSDeliveryMode(), message.getJMSPriority(), message.getJMSExpiration());
        } else {
            ((TopicPublisher)producer).send(destination, message, message.getJMSDeliveryMode(), message.getJMSPriority(), message.getJMSExpiration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNonCached(Message message, String destinationName) throws JMSException, JMSConnectorException {
        Connection connection = null;
        Session session = null;
        MessageProducer messageProducer = null;
        try {
            connection = this.jmsConnectionFactory.createConnection();
            session = this.jmsConnectionFactory.createSession(connection);
            Destination destination = this.jmsConnectionFactory.createDestination(session, destinationName);
            messageProducer = session.createProducer(destination);
            this.sendJMSMessage(destination, message, messageProducer);
        }
        catch (Throwable throwable) {
            this.jmsConnectionFactory.closeProducer(messageProducer);
            this.jmsConnectionFactory.closeSession(session);
            this.jmsConnectionFactory.closeConnection(connection);
            throw throwable;
        }
        this.jmsConnectionFactory.closeProducer(messageProducer);
        this.jmsConnectionFactory.closeSession(session);
        this.jmsConnectionFactory.closeConnection(connection);
    }

    private Message createJMSMessage(Session session, String messageType) throws JMSException {
        TextMessage jmsMessage = null;
        switch (messageType) {
            case "TextMessage": {
                jmsMessage = session.createTextMessage();
                break;
            }
            case "ObjectMessage": {
                jmsMessage = session.createObjectMessage();
                break;
            }
            case "MapMessage": {
                jmsMessage = session.createMapMessage();
                break;
            }
            case "BytesMessage": {
                jmsMessage = session.createBytesMessage();
                break;
            }
            case "StreamMessage": {
                jmsMessage = session.createStreamMessage();
                break;
            }
            default: {
                logger.error("Unsupported JMS Message type");
            }
        }
        if (jmsMessage != null) {
            jmsMessage.setJMSDeliveryMode(2);
            jmsMessage.setJMSPriority(4);
            jmsMessage.setJMSExpiration(0L);
        }
        return jmsMessage;
    }
}

