/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.jms.source;

import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.wso2.carbon.transport.jms.callback.JMSCallback;
import org.wso2.carbon.transport.jms.contract.JMSListener;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.extension.siddhi.io.jms.source.exception.JMSInputAdaptorRuntimeException;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;

public class JMSMessageProcessor
implements JMSListener {
    private SourceEventListener sourceEventListener;
    private boolean paused;
    private ReentrantLock lock;
    private Condition condition;
    private String[] requestedTransportPropertyNames;

    public JMSMessageProcessor(SourceEventListener sourceEventListener, SiddhiAppContext executionPlanContext, String[] requestedTransportPropertyNames) {
        this.sourceEventListener = sourceEventListener;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.requestedTransportPropertyNames = requestedTransportPropertyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Message message, JMSCallback jmsCallback) {
        if (this.paused) {
            this.lock.lock();
            try {
                this.condition.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
        try {
            if (message instanceof TextMessage) {
                String[] transportProperties = this.populateTransportHeaders(message);
                String event = ((TextMessage)message).getText();
                this.sourceEventListener.onEvent((Object)event, transportProperties);
            } else if (message instanceof MapMessage) {
                String[] transportProperties = this.populateTransportHeaders(message);
                HashMap<String, Object> event = new HashMap<String, Object>();
                MapMessage mapEvent = (MapMessage)message;
                Enumeration mapNames = mapEvent.getMapNames();
                while (mapNames.hasMoreElements()) {
                    String key = (String)mapNames.nextElement();
                    event.put(key, mapEvent.getObject(key));
                }
                this.sourceEventListener.onEvent(event, transportProperties);
            } else if (message instanceof ByteBuffer) {
                String[] transportProperties = this.populateTransportHeaders(message);
                this.sourceEventListener.onEvent((Object)message, transportProperties);
            } else {
                throw new JMSInputAdaptorRuntimeException("The message type of the JMS message" + message.getClass() + " is not supported!");
            }
            if (jmsCallback != null) {
                jmsCallback.done(true);
            }
        }
        catch (JMSException | JMSConnectorException e) {
            throw new JMSInputAdaptorRuntimeException("Failed to process JMS message.", e);
        }
    }

    private String[] populateTransportHeaders(Message message) throws JMSException, JMSConnectorException {
        if (this.requestedTransportPropertyNames.length > 0) {
            message.getPropertyNames();
            String[] properties = new String[this.requestedTransportPropertyNames.length];
            int i = 0;
            String[] stringArray = this.requestedTransportPropertyNames;
            int n = stringArray.length;
            block24: for (int j = 0; j < n; ++j) {
                String property;
                switch (property = stringArray[j]) {
                    case "JMS_REPLY_TO": {
                        if (message.getJMSReplyTo() == null) continue block24;
                        properties[i] = this.getDestinationName(message.getJMSReplyTo());
                        ++i;
                        continue block24;
                    }
                    case "JMS_DESTINATION": {
                        if (message.getJMSDestination() == null) continue block24;
                        properties[i] = this.getDestinationName(message.getJMSDestination());
                        ++i;
                        continue block24;
                    }
                    case "JMS_DELIVERY_MODE": {
                        properties[i] = String.valueOf(message.getJMSDeliveryMode());
                        ++i;
                        continue block24;
                    }
                    case "JMS_CORRELATION_ID": {
                        properties[i] = message.getJMSCorrelationID();
                        ++i;
                        continue block24;
                    }
                    case "JMS_EXPIRATION": {
                        properties[i] = String.valueOf(message.getJMSExpiration());
                        ++i;
                        continue block24;
                    }
                    case "JMS_MESSAGE_ID": {
                        properties[i] = message.getJMSMessageID();
                        ++i;
                        continue block24;
                    }
                    case "JMS_PRIORITY": {
                        properties[i] = String.valueOf(message.getJMSPriority());
                        ++i;
                        continue block24;
                    }
                    case "JMS_REDELIVERED": {
                        properties[i] = String.valueOf(message.getJMSRedelivered());
                        ++i;
                        continue block24;
                    }
                    case "JMS_TIMESTAMP": {
                        properties[i] = String.valueOf(message.getJMSTimestamp());
                        ++i;
                        continue block24;
                    }
                    case "JMS_TYPE": {
                        properties[i] = message.getJMSType();
                        ++i;
                        continue block24;
                    }
                    default: {
                        if (message.getStringProperty(property) != null) continue block24;
                        throw new JMSInputAdaptorRuntimeException(String.format("Specified property: %s is not available in the message", property));
                    }
                }
            }
            return properties;
        }
        return new String[0];
    }

    private String getDestinationName(Destination jmsDestination) throws JMSConnectorException {
        try {
            String destinationAsString;
            if (jmsDestination instanceof Queue) {
                destinationAsString = ((Queue)jmsDestination).getQueueName();
            } else if (jmsDestination instanceof Topic) {
                destinationAsString = ((Topic)jmsDestination).getTopicName();
            } else {
                throw new JMSConnectorException("Unknown JMS destination type. [ " + jmsDestination + " ]");
            }
            return destinationAsString;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error occurred while retrieving the destination name for JMS Destination [ " + jmsDestination + " ]", e);
        }
    }

    void pause() {
        this.paused = true;
    }

    void resume() {
        this.paused = false;
        try {
            this.lock.lock();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void disconnect() {
    }

    @Override
    public void onError(Throwable throwable) {
    }
}

