/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.factory;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.utils.JMSConstants;
import org.wso2.carbon.transport.jms.utils.JMSUtils;

public class JMSConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(JMSConnectionFactory.class);
    private Context ctx;
    private ConnectionFactory connectionFactory;
    private String connectionFactoryString;
    private JMSConstants.JMSDestinationType destinationType;
    private Destination destination;
    private String destinationName;
    private boolean transactedSession = false;
    private int sessionAckMode = 1;
    private String jmsSpec;
    private boolean isDurable;
    private boolean noPubSubLocal;
    private String clientId;
    private String subscriptionName;
    private String messageSelector;
    private boolean isSharedSubscription;

    public JMSConnectionFactory(Properties properties) throws JMSConnectorException {
        String msgSelector;
        String subDurable;
        try {
            this.ctx = new InitialContext(properties);
        }
        catch (NamingException e) {
            throw new JMSConnectorException("NamingException while obtaining initial context. ", e);
        }
        String connectionFactoryType = properties.getProperty("transport.jms.ConnectionFactoryType");
        this.destinationType = "topic".equalsIgnoreCase(connectionFactoryType) ? JMSConstants.JMSDestinationType.TOPIC : JMSConstants.JMSDestinationType.QUEUE;
        String jmsSpecVersion = properties.getProperty("transport.jms.JMSSpecVersion");
        if (null == jmsSpecVersion) {
            this.jmsSpec = "1.1";
        } else {
            switch (jmsSpecVersion) {
                case "1.1": {
                    this.jmsSpec = "1.1";
                    break;
                }
                case "2.0": {
                    this.jmsSpec = "2.0";
                    break;
                }
                case "1.0": {
                    this.jmsSpec = "1.0";
                    break;
                }
                default: {
                    this.jmsSpec = "1.1";
                }
            }
        }
        this.isSharedSubscription = "true".equalsIgnoreCase(properties.getProperty("transport.jms.SharedSubscription"));
        this.noPubSubLocal = Boolean.valueOf(properties.getProperty("transport.jms.PubSubNoLocal"));
        this.clientId = properties.getProperty("transport.jms.DurableSubscriberClientID");
        this.subscriptionName = properties.getProperty("transport.jms.DurableSubscriberName");
        if (this.isSharedSubscription && this.subscriptionName == null) {
            logger.warn("Subscription name is not given. Therefore declaring a non-shared subscription");
            this.isSharedSubscription = false;
        }
        if (null != (subDurable = properties.getProperty("transport.jms.SubscriptionDurable"))) {
            this.isDurable = Boolean.parseBoolean(subDurable);
        }
        if (null != (msgSelector = properties.getProperty("transport.jms.MessageSelector"))) {
            this.messageSelector = msgSelector;
        }
        this.connectionFactoryString = properties.getProperty("transport.jms.ConnectionFactoryJNDIName");
        if (null == this.connectionFactoryString || "".equals(this.connectionFactoryString)) {
            this.connectionFactoryString = "QueueConnectionFactory";
        }
        this.destinationName = properties.getProperty("transport.jms.Destination");
        String strSessionAck = properties.getProperty("transport.jms.SessionAcknowledgement");
        if (null == strSessionAck) {
            this.sessionAckMode = 1;
        } else if (strSessionAck.equals("CLIENT_ACKNOWLEDGE")) {
            this.sessionAckMode = 2;
        } else if (strSessionAck.equals("DUPS_OK_ACKNOWLEDGE")) {
            this.sessionAckMode = 3;
        } else if (strSessionAck.equals("SESSION_TRANSACTED")) {
            this.sessionAckMode = 0;
            this.transactedSession = true;
        }
        this.createConnectionFactory();
    }

    public ConnectionFactory getConnectionFactory() throws JMSConnectorException {
        if (this.connectionFactory != null) {
            return this.connectionFactory;
        }
        return this.createConnectionFactory();
    }

    private ConnectionFactory createConnectionFactory() throws JMSConnectorException {
        if (null != this.connectionFactory) {
            return this.connectionFactory;
        }
        try {
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                this.connectionFactory = (QueueConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
            } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                this.connectionFactory = (TopicConnectionFactory)this.ctx.lookup(this.connectionFactoryString);
            }
        }
        catch (NamingException e) {
            throw new JMSConnectorException("Naming exception while obtaining connection factory for " + this.connectionFactoryString, e);
        }
        return this.connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        if (null == this.connectionFactory) {
            throw new JMSException("Connection cannot be establish to the broker. Connection Factory is null. Please check the Please check the broker libs provided.");
        }
        Object connection = null;
        try {
            if ("1.1".equals(this.jmsSpec)) {
                if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                    connection = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
                } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                    connection = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
                    if (this.isDurable) {
                        connection.setClientID(this.clientId);
                    }
                }
                return connection;
            }
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                qConFac = (QueueConnectionFactory)this.connectionFactory;
            } else {
                tConFac = (TopicConnectionFactory)this.connectionFactory;
            }
            connection = null != qConFac ? qConFac.createQueueConnection() : tConFac.createTopicConnection();
            if (this.isDurable && !this.isSharedSubscription) {
                connection.setClientID(this.clientId);
            }
            return connection;
        }
        catch (JMSException e) {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    logger.error("Error while closing the connection. ", (Throwable)ex);
                }
            }
            throw e;
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        QueueConnection connection = null;
        try {
            if ("1.1".equals(this.jmsSpec)) {
                if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                    connection = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(userName, password);
                } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                    connection = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(userName, password);
                    if (this.isDurable) {
                        connection.setClientID(this.clientId);
                    }
                }
                return connection;
            }
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                qConFac = (QueueConnectionFactory)this.connectionFactory;
            } else {
                tConFac = (TopicConnectionFactory)this.connectionFactory;
            }
            if (null != qConFac) {
                connection = qConFac.createQueueConnection(userName, password);
            } else if (null != tConFac) {
                connection = tConFac.createTopicConnection(userName, password);
            }
            if (this.isDurable && !this.isSharedSubscription) {
                if (connection == null) {
                    throw new JMSException("Connection is null. Cannot set client ID " + this.clientId + "for durable subscription");
                }
                connection.setClientID(this.clientId);
            }
            return connection;
        }
        catch (JMSException e) {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    logger.error("Error while closing the connection", (Throwable)ex);
                }
            }
            throw e;
        }
    }

    public JMSContext createContext() {
        return this.connectionFactory.createContext();
    }

    public JMSContext createContext(int sessionMode) {
        return this.connectionFactory.createContext(sessionMode);
    }

    public JMSContext createContext(String userName, String password) {
        return this.connectionFactory.createContext(userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.connectionFactory.createContext(userName, password, sessionMode);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return ((TopicConnectionFactory)this.connectionFactory).createTopicConnection(userName, password);
    }

    public Destination getDestination(Session session) throws JMSConnectorException {
        if (null != this.destination) {
            return this.destination;
        }
        return this.createDestination(session);
    }

    public MessageConsumer getMessageConsumer(Session session, Destination destination) throws JMSConnectorException {
        return this.createMessageConsumer(session, destination);
    }

    public MessageConsumer createMessageConsumer(Session session, Destination destination) throws JMSConnectorException {
        try {
            if ("2.0".equals(this.jmsSpec) && this.isSharedSubscription) {
                if (this.isDurable) {
                    return session.createSharedDurableConsumer((Topic)destination, this.subscriptionName, this.messageSelector);
                }
                return session.createSharedConsumer((Topic)destination, this.subscriptionName, this.messageSelector);
            }
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec) && !this.isSharedSubscription) {
                if (this.isDurable) {
                    return session.createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.noPubSubLocal);
                }
                return session.createConsumer(destination, this.messageSelector);
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((QueueSession)session).createReceiver((Queue)destination, this.messageSelector);
            }
            if (this.isDurable) {
                return session.createDurableSubscriber((Topic)destination, this.subscriptionName, this.messageSelector, this.noPubSubLocal);
            }
            return ((TopicSession)session).createSubscriber((Topic)destination, this.messageSelector, false);
        }
        catch (Exception e) {
            throw new JMSConnectorException("JMS Exception while creating consumer for the destination " + this.destinationName, e);
        }
    }

    public MessageProducer getMessageProducer(Session session, Destination destination) throws JMSConnectorException {
        return this.createMessageProducer(session, destination);
    }

    public MessageProducer createMessageProducer(Session session, Destination destination) throws JMSConnectorException {
        try {
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                return session.createProducer(destination);
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((QueueSession)session).createSender((Queue)destination);
            }
            return ((TopicSession)session).createPublisher((Topic)destination);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while creating the producer for the destination " + this.destinationName, e);
        }
    }

    private Destination createDestination(Session session) throws JMSConnectorException {
        this.destination = this.createDestination(session, this.destinationName);
        return this.destination;
    }

    private Destination createDestination(Session session, String destinationName) throws JMSConnectorException {
        Destination destination = null;
        try {
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                destination = JMSUtils.lookupDestination(this.ctx, destinationName, "queue");
            } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                destination = JMSUtils.lookupDestination(this.ctx, destinationName, "topic");
            }
        }
        catch (NameNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not find destination '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'. " + e.getMessage());
                logger.debug("Creating destination '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + ".");
            }
            try {
                if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                    destination = session.createQueue(destinationName);
                } else if (JMSConstants.JMSDestinationType.TOPIC.equals((Object)this.destinationType)) {
                    destination = session.createTopic(destinationName);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Created '" + destinationName + "' on connection factory for '" + this.connectionFactoryString + "'.");
                }
            }
            catch (JMSException e1) {
                throw new JMSConnectorException("Could not find nor create '" + destinationName + "' on connection factory for " + this.connectionFactoryString, e1);
            }
        }
        catch (NamingException e) {
            throw new JMSConnectorException("Naming exception while looking up for the destination name " + destinationName, e);
        }
        return destination;
    }

    public Session getSession(Connection connection) throws JMSConnectorException {
        return this.createSession(connection);
    }

    public Session createSession(Connection connection) throws JMSConnectorException {
        try {
            if ("1.1".equals(this.jmsSpec) || "2.0".equals(this.jmsSpec)) {
                return connection.createSession(this.transactedSession, this.sessionAckMode);
            }
            if (JMSConstants.JMSDestinationType.QUEUE.equals((Object)this.destinationType)) {
                return ((QueueConnection)connection).createQueueSession(this.transactedSession, this.sessionAckMode);
            }
            return ((TopicConnection)connection).createTopicSession(this.transactedSession, this.sessionAckMode);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while obtaining session for factory " + this.connectionFactoryString, e);
        }
    }

    public void start(Connection connection) throws JMSConnectorException {
        try {
            connection.start();
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while starting connection for factory " + this.connectionFactoryString, e);
        }
    }

    public void stop(Connection connection) throws JMSConnectorException {
        try {
            if (null != connection) {
                connection.stop();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while stopping the connection for factory " + this.connectionFactoryString, e);
        }
    }

    public void closeConnection(Connection connection) throws JMSConnectorException {
        try {
            if (null != connection) {
                connection.close();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the connection. ", e);
        }
    }

    public void closeSession(Session session) throws JMSConnectorException {
        try {
            if (null != session) {
                session.close();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the session. ", e);
        }
    }

    public void closeMessageConsumer(MessageConsumer messageConsumer) throws JMSConnectorException {
        try {
            if (null != messageConsumer) {
                messageConsumer.close();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the subscriber. ", e);
        }
    }

    public void closeMessageProducer(MessageProducer messageProducer) throws JMSConnectorException {
        try {
            if (messageProducer != null) {
                messageProducer.close();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("JMS Exception while closing the producer. ", e);
        }
    }
}

