/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.receiver;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.receiver.JMSMessageConsumer;

class JMSConnectionRetryHandler {
    private JMSMessageConsumer messageConsumer;
    private static final Logger logger = LoggerFactory.getLogger(JMSConnectionRetryHandler.class);
    private long currentRetryInterval;
    private long retryInterval;
    private int retryCount = 0;
    private int maxRetryCount;
    private volatile boolean retrying = false;

    JMSConnectionRetryHandler(JMSMessageConsumer messageConsumer, long retryInterval, int maxRetryCount) {
        this.messageConsumer = messageConsumer;
        this.retryInterval = retryInterval;
        this.maxRetryCount = maxRetryCount;
        this.currentRetryInterval = retryInterval;
    }

    boolean retry() throws JMSConnectorException {
        if (this.retrying) {
            if (logger.isDebugEnabled()) {
                logger.debug("Retrying is in progress from a different thread, hence not retrying");
            }
            return false;
        }
        this.retrying = true;
        while (this.retryCount < this.maxRetryCount) {
            try {
                ++this.retryCount;
                this.messageConsumer.startConsuming();
                logger.info("Connected to the message broker after retrying for " + this.retryCount + " time(s)");
                this.retryCount = 0;
                this.currentRetryInterval = this.retryInterval;
                this.retrying = false;
                return true;
            }
            catch (JMSConnectorException e) {
                try {
                    this.messageConsumer.closeAll();
                }
                catch (JMSConnectorException ex) {
                    logger.debug("Failed to close erroneous connection. This could be due to a broken connection.", (Throwable)((Object)ex));
                }
                if (this.retryCount >= this.maxRetryCount) continue;
                logger.error("Retry connection attempt " + this.retryCount + " to JMS Provider failed. Retry will be " + "attempted again after " + TimeUnit.SECONDS.convert(this.currentRetryInterval, TimeUnit.MILLISECONDS) + " seconds");
                try {
                    TimeUnit.MILLISECONDS.sleep(this.currentRetryInterval);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                this.currentRetryInterval *= 2L;
            }
        }
        this.retrying = false;
        throw new JMSConnectorException("Connection to the jms provider failed after retrying for " + this.retryCount + " times");
    }
}

