/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.sender;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.SerializableCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.messaging.exceptions.ClientConnectorException;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.factory.CachedJMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.JMSConnectionFactory;
import org.wso2.carbon.transport.jms.factory.PooledJMSConnectionFactory;
import org.wso2.carbon.transport.jms.utils.JMSConstants;

public class JMSClientConnector
implements ClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(JMSClientConnector.class);
    private MessageProducer messageProducer;
    private Session session;
    private Connection connection;
    private JMSConnectionFactory jmsConnectionFactory;

    public boolean send(CarbonMessage carbonMessage, CarbonCallback carbonCallback) throws ClientConnectorException {
        return false;
    }

    public synchronized boolean send(CarbonMessage carbonMessage, CarbonCallback carbonCallback, Map<String, String> propertyMap) throws ClientConnectorException {
        block18: {
            try {
                TextMessage message;
                block21: {
                    String messageType;
                    block19: {
                        String textData;
                        block20: {
                            try {
                                Set<Map.Entry<String, String>> propertySet = propertyMap.entrySet();
                                this.createConnection(propertySet);
                            }
                            catch (JMSConnectorException e) {
                                throw new ClientConnectorException(e.getMessage(), (Throwable)((Object)e));
                            }
                            message = null;
                            messageType = propertyMap.get("JMS_MESSAGE_TYPE");
                            if (!(carbonMessage instanceof TextCarbonMessage)) break block19;
                            textData = ((TextCarbonMessage)carbonMessage).getText();
                            if (!messageType.equals("TextMessage")) break block20;
                            TextMessage textMessage = message = this.session.createTextMessage();
                            textMessage.setText(textData);
                            break block21;
                        }
                        if (!messageType.equals("BytesMessage")) break block21;
                        message = this.session.createBytesMessage();
                        BytesMessage bytesMessage = (BytesMessage)message;
                        bytesMessage.writeBytes(textData.getBytes(Charset.defaultCharset()));
                        break block21;
                    }
                    if (messageType.equals("ObjectMessage") && carbonMessage instanceof SerializableCarbonMessage) {
                        message = this.session.createObjectMessage((Serializable)((SerializableCarbonMessage)carbonMessage));
                    } else if (messageType.equals("MapMessage") && carbonMessage instanceof MapCarbonMessage) {
                        message = this.session.createMapMessage();
                        MapMessage mapMessage = (MapMessage)message;
                        Enumeration mapNames = ((MapCarbonMessage)carbonMessage).getMapNames();
                        while (mapNames.hasMoreElements()) {
                            String key = (String)mapNames.nextElement();
                            mapMessage.setString(key, ((MapCarbonMessage)carbonMessage).getValue(key));
                        }
                    }
                }
                if (carbonMessage.getProperty("Persistence") != null && carbonMessage.getProperty("Persistence").equals(false)) {
                    this.messageProducer.setDeliveryMode(1);
                }
                if (message != null) {
                    this.messageProducer.send((Message)message);
                    break block18;
                }
                throw new ClientConnectorException("Exception occured while creating the message");
            }
            catch (JMSException e) {
                throw new ClientConnectorException("Exception occurred while sending the message", (Throwable)e);
            }
            finally {
                if (this.jmsConnectionFactory != null) {
                    try {
                        this.jmsConnectionFactory.closeMessageProducer(this.messageProducer);
                        this.jmsConnectionFactory.closeSession(this.session);
                        this.jmsConnectionFactory.closeConnection(this.connection);
                    }
                    catch (JMSConnectorException e) {
                        logger.error("Exception occured when closing connection " + e.getMessage(), (Throwable)((Object)e));
                    }
                }
            }
        }
        return false;
    }

    private void createConnection(Set<Map.Entry<String, String>> propertySet) throws JMSConnectorException, JMSException {
        Session session;
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : propertySet) {
            String mappedParameter = JMSConstants.MAPPING_PARAMETERS.get(entry.getKey());
            if (mappedParameter != null) {
                properties.put(mappedParameter, entry.getValue());
                continue;
            }
            properties.put(entry.getKey(), entry.getValue());
        }
        String connectionFactoryNature = properties.getProperty("connectionFactoryNature");
        if (connectionFactoryNature != null) {
            switch (connectionFactoryNature) {
                case "cached": {
                    this.jmsConnectionFactory = new CachedJMSConnectionFactory(properties);
                    break;
                }
                case "pooled": {
                    this.jmsConnectionFactory = new PooledJMSConnectionFactory(properties);
                    break;
                }
                default: {
                    this.jmsConnectionFactory = new JMSConnectionFactory(properties);
                    break;
                }
            }
        } else {
            this.jmsConnectionFactory = new JMSConnectionFactory(properties);
        }
        String conUsername = properties.getProperty("connectionUsername");
        String conPassword = properties.getProperty("connectionPassword");
        Connection connection = conUsername != null && conPassword != null ? this.jmsConnectionFactory.createConnection(conUsername, conPassword) : this.jmsConnectionFactory.createConnection();
        this.connection = connection;
        this.session = session = this.jmsConnectionFactory.getSession(connection);
        Destination destination = this.jmsConnectionFactory.getDestination(session);
        this.messageProducer = this.jmsConnectionFactory.getMessageProducer(session, destination);
    }

    public String getProtocol() {
        return "jms";
    }

    public void setMessageProcessor(CarbonMessageProcessor messageProcessor) {
    }
}

