/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.utils;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.SerializableCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;

public class JMSUtils {
    public static Destination lookupDestination(Context context, String destinationName, String destinationType) throws NamingException {
        if (null == destinationName) {
            return null;
        }
        return JMSUtils.lookup(context, Destination.class, destinationName);
    }

    private static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            if (object instanceof Reference) {
                Reference ref = (Reference)object;
                String errorMessage = "JNDI failed to de-reference Reference with name " + name + "; is the " + "factory " + ref.getFactoryClassName() + " in your classpath?";
                throw new NamingException(errorMessage);
            }
            String errorMessage = "JNDI lookup of name " + name + " returned a " + object.getClass().getName() + " while a " + clazz + " was expected";
            throw new NamingException(errorMessage);
        }
    }

    public static CarbonMessage createJMSCarbonMessage(Message message) throws JMSConnectorException {
        TextCarbonMessage jmsCarbonMessage = null;
        try {
            if (message instanceof TextMessage) {
                jmsCarbonMessage = new TextCarbonMessage(((TextMessage)message).getText());
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"TextMessage");
            } else if (message instanceof MapMessage) {
                MapCarbonMessage mapCarbonMessage = new MapCarbonMessage();
                MapMessage mapMessage = (MapMessage)message;
                Enumeration mapKeys = ((MapMessage)message).getMapNames();
                while (mapKeys.hasMoreElements()) {
                    String mapKey = (String)mapKeys.nextElement();
                    String mapValue = mapMessage.getString(mapKey);
                    if (null == mapValue) continue;
                    mapCarbonMessage.setValue(mapKey, mapValue);
                }
                jmsCarbonMessage = mapCarbonMessage;
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"MapMessage");
            } else if (message instanceof ObjectMessage) {
                try {
                    if (((ObjectMessage)message).getObject() instanceof SerializableCarbonMessage) {
                        jmsCarbonMessage = (SerializableCarbonMessage)((ObjectMessage)message).getObject();
                    } else {
                        SerializableCarbonMessage serializableCarbonMessage = new SerializableCarbonMessage();
                        serializableCarbonMessage.setPayload(((ObjectMessage)message).getObject().toString());
                        jmsCarbonMessage = serializableCarbonMessage;
                    }
                }
                catch (MessageFormatException e) {
                    jmsCarbonMessage = new SerializableCarbonMessage();
                }
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"ObjectMessage");
            } else {
                jmsCarbonMessage = new TextCarbonMessage(((BytesMessage)message).readUTF());
                jmsCarbonMessage.setProperty("JMS_MESSAGE_TYPE", (Object)"BytesMessage");
            }
            String messageId = message.getJMSMessageID();
            if (null != messageId) {
                jmsCarbonMessage.setHeader("JMS_MESSAGE_ID", messageId);
            }
            jmsCarbonMessage.setHeader("JMS_DELIVERY_MODE", String.valueOf(message.getJMSDeliveryMode()));
            jmsCarbonMessage.setHeader("JMS_PRIORITY", String.valueOf(message.getJMSPriority()));
            jmsCarbonMessage.setHeader("JMS_RE_DELIVERED", String.valueOf(message.getJMSRedelivered()));
            jmsCarbonMessage.setHeader("JMS_TIME_STAMP", String.valueOf(message.getJMSTimestamp()));
            Enumeration properties = message.getPropertyNames();
            while (properties.hasMoreElements()) {
                String name = (String)properties.nextElement();
                jmsCarbonMessage.setHeader(name, message.getStringProperty(name));
            }
            return jmsCarbonMessage;
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while changing the jms message to carbon message", e);
        }
    }
}

