/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.jms.source;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;
import org.wso2.carbon.transport.jms.exception.JMSConnectorException;
import org.wso2.carbon.transport.jms.receiver.JMSServerConnector;
import org.wso2.extension.siddhi.io.jms.source.JMSMessageProcessor;
import org.wso2.extension.siddhi.io.jms.util.JMSOptionsMapper;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.input.source.Source;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.OptionHolder;

@Extension(name="jms", namespace="source", description="JMS Source", examples={@Example(description="TBD", syntax="TBD")})
public class JMSSource
extends Source {
    private static final Logger log = Logger.getLogger(JMSSource.class);
    private SourceEventListener sourceEventListener;
    private OptionHolder optionHolder;
    private JMSServerConnector jmsServerConnector;
    private JMSMessageProcessor jmsMessageProcessor;
    private static final String THREAD_COUNT = "worker.count";
    private static final String DEFAULT_THREAD_COUNT = "1";
    private int concurrentConsumers;

    public void init(SourceEventListener sourceEventListener, OptionHolder optionHolder, ConfigReader configReader, SiddhiAppContext executionPlanContext) {
        this.sourceEventListener = sourceEventListener;
        this.optionHolder = optionHolder;
        this.concurrentConsumers = Integer.parseInt(optionHolder.validateAndGetStaticValue(THREAD_COUNT, DEFAULT_THREAD_COUNT));
        Map<String, String> properties = this.initJMSProperties();
        this.jmsServerConnector = new JMSServerConnector(properties);
        this.jmsMessageProcessor = new JMSMessageProcessor(sourceEventListener, executionPlanContext);
        this.jmsServerConnector.setMessageProcessor(this.jmsMessageProcessor);
    }

    public void connect() throws ConnectionUnavailableException {
        try {
            this.jmsServerConnector.start();
        }
        catch (ServerConnectorException e) {
            throw new ConnectionUnavailableException("Exception in starting the JMS receiver for stream: " + this.sourceEventListener.getStreamDefinition().getId(), (Throwable)e);
        }
    }

    public void disconnect() {
        try {
            if (this.jmsServerConnector != null && this.jmsServerConnector.getState() != ServerConnector.State.UNINITIALIZED) {
                this.jmsServerConnector.stop();
            }
            if (this.jmsMessageProcessor != null) {
                this.jmsMessageProcessor.disconnect();
            }
        }
        catch (JMSConnectorException e) {
            log.error((Object)"Error disconnecting the JMS receiver", (Throwable)((Object)e));
        }
    }

    public void destroy() {
    }

    public void pause() {
        this.jmsMessageProcessor.pause();
    }

    public void resume() {
        this.jmsMessageProcessor.resume();
    }

    private Map<String, String> initJMSProperties() {
        Map<String, String> carbonPropertyMapping = JMSOptionsMapper.getCarbonPropertyMapping();
        List<String> requiredOptions = JMSOptionsMapper.getRequiredOptions();
        HashMap<String, String> transportProperties = new HashMap<String, String>();
        requiredOptions.forEach(requiredOption -> transportProperties.put((String)carbonPropertyMapping.get(requiredOption), this.optionHolder.validateAndGetStaticValue(requiredOption)));
        this.optionHolder.getStaticOptionsKeys().stream().filter(option -> !requiredOptions.contains(option) && !option.equals("type")).forEach(option -> transportProperties.put((String)option, this.optionHolder.validateAndGetStaticValue(option)));
        transportProperties.put("concurrentConsumers", String.valueOf(this.concurrentConsumers));
        return transportProperties;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

