/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.jms.sink;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.wso2.transport.jms.contract.JMSClientConnector;
import org.wso2.transport.jms.exception.JMSConnectorException;

public class JMSPublisher
implements Runnable {
    private static final Logger log = Logger.getLogger(JMSPublisher.class);
    private Map<String, String> jmsProperties = new HashMap<String, String>();
    private JMSClientConnector jmsClientConnector;
    private Message message;

    public JMSPublisher(String destination, Map<String, String> staticJMSProperties, JMSClientConnector jmsClientConnector, Object payload) throws UnsupportedEncodingException {
        this.jmsProperties.putAll(staticJMSProperties);
        this.jmsProperties.put("transport.jms.Destination", destination);
        this.jmsClientConnector = jmsClientConnector;
        try {
            this.message = this.handleMessage(payload);
        }
        catch (JMSException | JMSConnectorException e) {
            log.error((Object)("Failed to process payload: " + e.getMessage()));
        }
    }

    @Override
    public void run() {
        try {
            this.jmsClientConnector.send(this.message, this.jmsProperties.get("transport.jms.Destination"));
        }
        catch (JMSConnectorException e) {
            log.error((Object)("Error sending JMS message: " + e.getMessage()));
        }
    }

    private Message handleMessage(Object payload) throws UnsupportedEncodingException, JMSConnectorException, JMSException {
        if (payload instanceof String) {
            TextMessage message = (TextMessage)this.jmsClientConnector.createMessage("TextMessage");
            message.setText(payload.toString());
            return message;
        }
        if (payload instanceof Map) {
            MapMessage message = (MapMessage)this.jmsClientConnector.createMessage("MapMessage");
            ((Map)payload).forEach((key, value) -> {
                try {
                    message.setObject((String)key, value);
                }
                catch (JMSException e) {
                    log.error((Object)("Error while adding into message properties. " + e.getMessage()));
                }
            });
            return message;
        }
        if (payload instanceof ByteBuffer) {
            byte[] data = ((ByteBuffer)payload).array();
            BytesMessage message = (BytesMessage)this.jmsClientConnector.createMessage("BytesMessage");
            message.writeBytes(data);
            return message;
        }
        throw new UnsupportedEncodingException("The type of the output payload cannot be cast to String, Map or Byte[] from JMS");
    }
}

