/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.jms.sink;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;
import org.wso2.extension.siddhi.io.jms.sink.exception.JMSSinkAdaptorRuntimeException;
import org.wso2.transport.jms.contract.JMSClientConnector;
import org.wso2.transport.jms.exception.JMSConnectorException;

public class JMSPublisher
implements Runnable {
    private static final Logger log = Logger.getLogger(JMSPublisher.class);
    private Map<String, String> jmsProperties = new HashMap<String, String>();
    private JMSClientConnector jmsClientConnector;
    private Message message;

    public JMSPublisher(String destination, Map<String, String> staticJMSProperties, JMSClientConnector jmsClientConnector, Object payload) {
        this.jmsProperties.putAll(staticJMSProperties);
        this.jmsProperties.put("transport.jms.Destination", destination);
        this.jmsClientConnector = jmsClientConnector;
        try {
            this.message = this.handleMessage(payload);
        }
        catch (JMSException | JMSConnectorException e) {
            throw new JMSSinkAdaptorRuntimeException("Error while processing the JMS message to destination " + destination, e);
        }
    }

    @Override
    public void run() {
        try {
            this.jmsClientConnector.send(this.message, this.jmsProperties.get("transport.jms.Destination"));
        }
        catch (JMSConnectorException e) {
            log.error((Object)("Error sending JMS message to destination: " + this.jmsProperties.get("transport.jms.Destination")), (Throwable)e);
            throw new JMSSinkAdaptorRuntimeException("Error sending JMS message to destination:" + this.jmsProperties.get("transport.jms.Destination"), e);
        }
    }

    private Message handleMessage(Object payload) throws JMSException, JMSConnectorException {
        if (payload instanceof String) {
            TextMessage message = (TextMessage)this.jmsClientConnector.createMessage("TextMessage");
            message.setText(payload.toString());
            return message;
        }
        if (payload instanceof Map) {
            MapMessage message = (MapMessage)this.jmsClientConnector.createMessage("MapMessage");
            ((Map)payload).forEach((key, value) -> {
                try {
                    message.setObject((String)key, value);
                }
                catch (JMSException e) {
                    throw new JMSSinkAdaptorRuntimeException("Error while adding property " + key + " and value" + value + " into message properties.", e);
                }
            });
            return message;
        }
        if (payload instanceof ByteBuffer) {
            byte[] data = ((ByteBuffer)payload).array();
            BytesMessage message = (BytesMessage)this.jmsClientConnector.createMessage("BytesMessage");
            message.writeBytes(data);
            return message;
        }
        throw new JMSSinkAdaptorRuntimeException("The message type of the JMS message " + this.message.getClass() + " is not supported!");
    }
}

