/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.jms.receiver;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.jms.contract.JMSListener;
import org.wso2.transport.jms.exception.JMSConnectorException;
import org.wso2.transport.jms.factory.JMSServerConnectionFactory;
import org.wso2.transport.jms.receiver.JMSConnectionRetryHandler;
import org.wso2.transport.jms.receiver.JMSExceptionListener;
import org.wso2.transport.jms.receiver.JMSMessageListener;
import org.wso2.transport.jms.receiver.JMSMessageReceiver;

public class JMSMessageConsumer
implements MessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JMSMessageConsumer.class);
    private JMSServerConnectionFactory connectionFactory = null;
    private MessageConsumer messageConsumer;
    private boolean useReceiver = false;
    private Connection connection;
    private Session session;
    private Destination destination;
    private String serviceId;
    private JMSListener jmsListener;
    private JMSConnectionRetryHandler retryHandler;
    private long retryInterval = 10000L;
    private int maxRetryCount = 5;
    private JMSMessageReceiver messageReceiver;

    public JMSMessageConsumer(JMSServerConnectionFactory connectionFactory, boolean useReceiver, JMSListener jmsListener, String serviceId, long retryInterval, int maxRetryCount) throws JMSConnectorException {
        this.connectionFactory = connectionFactory;
        this.useReceiver = useReceiver;
        this.jmsListener = jmsListener;
        this.serviceId = serviceId;
        this.retryInterval = retryInterval;
        this.maxRetryCount = maxRetryCount;
        this.retryHandler = new JMSConnectionRetryHandler(this, this.retryInterval, this.maxRetryCount);
        this.startConsuming();
    }

    void startConsuming() throws JMSConnectorException {
        block9: {
            try {
                this.connection = this.connectionFactory.createConnection();
                ExceptionListener exceptionListener = this.connection.getExceptionListener();
                if (exceptionListener == null) {
                    JMSExceptionListener jmsExceptionListener = new JMSExceptionListener(this);
                    this.connection.setExceptionListener((ExceptionListener)jmsExceptionListener);
                } else if (exceptionListener instanceof JMSExceptionListener) {
                    ((JMSExceptionListener)exceptionListener).addConsumer(this);
                } else {
                    throw new JMSConnectorException("This connection is already assigned with an unknown exception handler");
                }
                this.connectionFactory.start(this.connection);
                this.session = this.connectionFactory.createSession(this.connection);
                Destination destination = this.connectionFactory.getDestination(this.session);
                this.messageConsumer = this.connectionFactory.createMessageConsumer(this.session, destination);
                if (this.useReceiver) {
                    this.createMessageReceiver();
                } else {
                    this.createMessageListener();
                }
            }
            catch (JMSSecurityException e) {
                throw new JMSConnectorException("Security error occurred when starting the consumer", e);
            }
            catch (JMSException | JMSConnectorException e) {
                if (this.retryHandler.retry()) break block9;
                throw new JMSConnectorException("Connection to JMS server failed and retry was not successful", e);
            }
        }
    }

    public void closeAll() throws JMSConnectorException {
        try {
            if (this.useReceiver) {
                this.messageReceiver.stopMessageReceiver();
            }
            this.connectionFactory.closeConsumer(this.messageConsumer);
            this.connectionFactory.closeSession(this.session);
            this.connectionFactory.closeConnection(this.connection);
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error closing connection/session/consumer of JMS Service " + this.serviceId, e);
        }
        finally {
            this.messageConsumer = null;
            this.session = null;
            this.connection = null;
        }
    }

    private void createMessageListener() throws JMSConnectorException {
        try {
            this.messageConsumer.setMessageListener((MessageListener)new JMSMessageListener(this.jmsListener, this.serviceId, this.session));
            if (logger.isDebugEnabled()) {
                logger.debug("Message listener created for service " + this.serviceId);
            }
        }
        catch (JMSException e) {
            throw new JMSConnectorException("Error while initializing message listener", e);
        }
    }

    private void createMessageReceiver() throws JMSConnectorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating message receiver for service " + this.serviceId);
        }
        this.messageReceiver = new JMSMessageReceiver(this.jmsListener, this.serviceId, this.session, this);
        this.messageReceiver.receive();
    }

    void stop() throws JMSConnectorException {
        this.connectionFactory.stop(this.connection);
    }

    void start() throws JMSConnectorException, JMSSecurityException {
        this.connectionFactory.start(this.connection);
    }

    public String getMessageSelector() throws JMSException {
        return this.messageConsumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.messageConsumer.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.messageConsumer.setMessageListener(listener);
    }

    public Message receive() throws JMSException {
        return this.messageConsumer.receive();
    }

    public Message receive(long timeout) throws JMSException {
        return this.messageConsumer.receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.messageConsumer.receiveNoWait();
    }

    public void close() throws JMSException {
        this.messageConsumer.close();
    }
}

