/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.jms.source;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.extension.siddhi.io.jms.source.exception.JMSInputAdaptorRuntimeException;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;

public class JMSMessageProcessor
implements CarbonMessageProcessor {
    private SourceEventListener sourceEventListener;
    private boolean paused;
    private ReentrantLock lock;
    private Condition condition;
    private String[] requestedTransportPropertyNames;

    public JMSMessageProcessor(SourceEventListener sourceEventListener, SiddhiAppContext executionPlanContext, String[] requestedTransportPropertyNames) {
        this.sourceEventListener = sourceEventListener;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.requestedTransportPropertyNames = requestedTransportPropertyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(CarbonMessage carbonMessage, CarbonCallback carbonCallback) throws Exception {
        if (this.paused) {
            this.lock.lock();
            try {
                this.condition.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
        try {
            if (carbonMessage.getClass() == TextCarbonMessage.class) {
                String[] transportProperties = this.populateTransportHeaders(carbonMessage);
                String event = ((TextCarbonMessage)carbonMessage).getText();
                this.sourceEventListener.onEvent((Object)event, transportProperties);
            } else if (carbonMessage.getClass() == MapCarbonMessage.class) {
                String[] transportProperties = this.populateTransportHeaders(carbonMessage);
                HashMap<String, String> event = new HashMap<String, String>();
                MapCarbonMessage mapCarbonMessage = (MapCarbonMessage)carbonMessage;
                Enumeration mapNames = mapCarbonMessage.getMapNames();
                while (mapNames.hasMoreElements()) {
                    String key = (String)mapNames.nextElement();
                    event.put(key, mapCarbonMessage.getValue(key));
                }
                this.sourceEventListener.onEvent(event, transportProperties);
            } else {
                throw new JMSInputAdaptorRuntimeException("The message type of the JMS message" + carbonMessage.getClass() + " is not supported!");
            }
            if (carbonCallback != null) {
                carbonCallback.done(carbonMessage);
            }
        }
        catch (RuntimeException e) {
            throw new JMSInputAdaptorRuntimeException("Failed to process JMS message.", e);
        }
        return true;
    }

    private String[] populateTransportHeaders(CarbonMessage carbonMessage) {
        if (this.requestedTransportPropertyNames.length > 0) {
            String[] properties = new String[this.requestedTransportPropertyNames.length];
            int i = 0;
            for (String property : this.requestedTransportPropertyNames) {
                properties[i] = carbonMessage.getHeader(property);
                ++i;
            }
            return properties;
        }
        return new String[0];
    }

    public void setTransportSender(TransportSender transportSender) {
    }

    public void setClientConnector(ClientConnector clientConnector) {
    }

    public String getId() {
        return "JMS-message-processor";
    }

    void pause() {
        this.paused = true;
    }

    void resume() {
        this.paused = false;
        try {
            this.lock.lock();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void disconnect() {
    }
}

