/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.rabbitmq.util;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.util.config.ConfigReader;

public class RabbitMQSinkUtil {
    private static final Logger log = Logger.getLogger(RabbitMQSinkUtil.class);

    public static void declareExchange(Connection connection, Channel channel, String exchangeName, String exchangeType, boolean exchangeDurable, boolean exchangeAutodelete) throws IOException, TimeoutException {
        try {
            channel.exchangeDeclare(exchangeName, exchangeType, exchangeDurable, exchangeAutodelete, null);
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while declaring the exchange - " + RabbitMQSinkUtil.removeCRLFCharacters(exchangeName) + "."), (Throwable)e);
        }
    }

    public static void declareQueue(Connection connection, Channel channel, String queueName, boolean queueDurable, boolean queueAutodelete, boolean queueExclusive) throws IOException, TimeoutException {
        try {
            channel.queueDeclare(queueName, queueDurable, queueExclusive, queueAutodelete, null);
        }
        catch (IOException e) {
            log.error((Object)("Error occurred while declaring the queue " + RabbitMQSinkUtil.removeCRLFCharacters(queueName) + "."), (Throwable)e);
        }
    }

    public static String getTrustStorePath(ConfigReader sinkConfigReader) {
        return sinkConfigReader.readConfig("tls.truststore.path", "");
    }

    public static String getTrustStorePassword(ConfigReader sinkConfigReader) {
        return sinkConfigReader.readConfig("tls.truststore.password", "wso2carbon");
    }

    public static Map<String, Object> getHeaders(String headers) throws IOException {
        headers = headers.trim();
        headers = headers.substring(1, headers.length() - 1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!headers.isEmpty()) {
            String[] spam;
            for (String aSpam : spam = headers.split("','")) {
                String[] header = aSpam.split(":", 2);
                if (header.length <= 1) {
                    throw new IOException("Invalid header format. Please include as 'key1:value1','key2:value2',..");
                }
                map.put(header[0], header[1]);
            }
        }
        return map;
    }

    private static String removeCRLFCharacters(String str) {
        return str.replace('\n', '_').replace('\r', '_');
    }
}

