/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.StreamController;
import twitter4j.TwitterException;

public final class ControlStreamInfo
implements Serializable {
    private static final long serialVersionUID = 5182091913786509723L;
    private final StreamController.User[] users;
    private final boolean includeFollowingsActivity;
    private final boolean includeUserChanges;
    private final String replies;
    private final String with;

    ControlStreamInfo(StreamController controller, JSONObject json) throws TwitterException {
        try {
            JSONObject info = json.getJSONObject("info");
            this.includeFollowingsActivity = ParseUtil.getBoolean("include_followings_activity", info);
            this.includeUserChanges = ParseUtil.getBoolean("include_user_changes", info);
            this.replies = ParseUtil.getRawString("replies", info);
            this.with = ParseUtil.getRawString("with", info);
            JSONArray usersJSON = info.getJSONArray("users");
            this.users = new StreamController.User[usersJSON.length()];
            for (int i = 0; i < usersJSON.length(); ++i) {
                this.users[i] = controller.createUser(usersJSON.getJSONObject(i));
            }
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    public StreamController.User[] getUsers() {
        return this.users;
    }

    public boolean isIncludeFollowingsActivity() {
        return this.includeFollowingsActivity;
    }

    public boolean isIncludeUserChanges() {
        return this.includeUserChanges;
    }

    public String isReplies() {
        return this.replies;
    }

    public String isWith() {
        return this.with;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlStreamInfo that = (ControlStreamInfo)o;
        if (this.includeFollowingsActivity != that.includeFollowingsActivity) {
            return false;
        }
        if (this.includeUserChanges != that.includeUserChanges) {
            return false;
        }
        if (this.replies != null ? !this.replies.equals(that.replies) : that.replies != null) {
            return false;
        }
        if (!Arrays.equals(this.users, that.users)) {
            return false;
        }
        return !(this.with != null ? !this.with.equals(that.with) : that.with != null);
    }

    public int hashCode() {
        int result = this.users != null ? Arrays.hashCode(this.users) : 0;
        result = 31 * result + (this.includeFollowingsActivity ? 1 : 0);
        result = 31 * result + (this.includeUserChanges ? 1 : 0);
        result = 31 * result + (this.replies != null ? this.replies.hashCode() : 0);
        result = 31 * result + (this.with != null ? this.with.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ControlStreamInfo{users=" + (this.users == null ? null : Arrays.asList(this.users)) + ", includeFollowingsActivity=" + this.includeFollowingsActivity + ", includeUserChanges=" + this.includeUserChanges + ", replies='" + this.replies + '\'' + ", with='" + this.with + '\'' + '}';
    }
}

