/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.twitter.source;

import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.wso2.extension.siddhi.io.twitter.util.Util;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;

public class TwitterStatusListener
implements StatusListener {
    private static final Logger log = Logger.getLogger(TwitterStatusListener.class);
    private SourceEventListener sourceEventListener;
    private boolean paused;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    TwitterStatusListener(SourceEventListener sourceEventListener) {
        this.sourceEventListener = sourceEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatus(Status status) {
        if (this.paused) {
            this.lock.lock();
            try {
                while (this.paused) {
                    this.condition.await();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
        Map<String, Object> event = Util.createMap(status);
        this.sourceEventListener.onEvent(event, null);
    }

    @Override
    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        log.debug((Object)("Got a status deletion notice id:" + statusDeletionNotice.getStatusId()));
    }

    @Override
    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
        log.debug((Object)("Got track limitation notice: " + numberOfLimitedStatuses));
    }

    @Override
    public void onScrubGeo(long userId, long upToStatusId) {
        log.debug((Object)("Got scrub_geo event userId:" + userId + " upToStatusId:" + upToStatusId));
    }

    @Override
    public void onStallWarning(StallWarning warning) {
        log.debug((Object)("Got stall warning:" + warning));
    }

    @Override
    public void onException(Exception ex) {
        log.error((Object)"Twitter source threw an exception", (Throwable)ex);
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
        try {
            this.lock.lock();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

