/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.twitter.util;

import java.util.HashMap;
import java.util.Map;
import org.wso2.extension.siddhi.io.twitter.util.QueryBuilder;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import twitter4j.Status;

public class Util {
    private Util() {
    }

    public static double[][] locationParam(String locationParam) {
        String[] boundary = locationParam.split(",");
        if (boundary.length < 5) {
            throw new SiddhiAppValidationException("For the location, the bounding box specified is invalid.");
        }
        double[][] locations = new double[boundary.length / 2][2];
        int k = 0;
        for (int i = 0; i < boundary.length / 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                try {
                    locations[i][j] = Double.parseDouble(boundary[k++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SiddhiAppValidationException("Latitude/Longitude should be a double value: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return locations;
    }

    public static long[] followParam(String followParam) {
        long[] follow = new long[followParam.split(",").length];
        for (int i = 0; i < followParam.split(",").length; ++i) {
            try {
                follow[i] = Long.parseLong(followParam.split(",")[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new SiddhiAppValidationException("Follow should be a long value: " + e.getMessage(), (Throwable)e);
            }
        }
        return follow;
    }

    public static Map<String, Object> createMap(Status tweet) {
        int i;
        HashMap<String, Object> status = new HashMap<String, Object>();
        String trackwords = QueryBuilder.getTrackParam() != null && !QueryBuilder.getTrackParam().isEmpty() ? QueryBuilder.getTrackParam() : "null";
        String query = QueryBuilder.getQueryParam() != null && !QueryBuilder.getQueryParam().isEmpty() ? QueryBuilder.getQueryParam() : "null";
        String geoLocation = tweet.getGeoLocation() == null ? "null" : tweet.getGeoLocation().getLatitude() + "," + tweet.getGeoLocation().getLongitude();
        StringBuilder hashtag = new StringBuilder();
        StringBuilder userMention = new StringBuilder();
        StringBuilder mediaUrl = new StringBuilder();
        StringBuilder url = new StringBuilder();
        for (i = 0; i < tweet.getHashtagEntities().length; ++i) {
            hashtag.append(tweet.getHashtagEntities()[i].getText() + ",");
        }
        String hashtags = hashtag.toString();
        hashtags = hashtags.equals("") ? "null" : hashtags.substring(0, hashtags.length() - 1);
        for (i = 0; i < tweet.getUserMentionEntities().length; ++i) {
            userMention.append(tweet.getUserMentionEntities()[i].getText() + ",");
        }
        String userMentions = userMention.toString();
        userMentions = userMentions.equals("") ? "null" : userMentions.substring(0, userMentions.length() - 1);
        for (i = 0; i < tweet.getMediaEntities().length; ++i) {
            mediaUrl.append(tweet.getMediaEntities()[i].getMediaURL() + ",");
        }
        String mediaUrls = mediaUrl.toString();
        mediaUrls = mediaUrls.equals("") ? "null" : mediaUrls.substring(0, mediaUrls.length() - 1);
        for (i = 0; i < tweet.getURLEntities().length; ++i) {
            url.append(tweet.getURLEntities()[i].getURL() + ",");
        }
        String urls = url.toString();
        urls = urls.equals("") ? "null" : urls.substring(0, urls.length() - 1);
        String createdAt = tweet.getCreatedAt().toString();
        status.put("createdAt", createdAt);
        status.put("tweetId", tweet.getId());
        status.put("text", tweet.getText());
        status.put("user.createdAt", tweet.getUser().getCreatedAt());
        status.put("user.screenName", tweet.getUser().getScreenName());
        status.put("user.name", tweet.getUser().getName());
        status.put("user.mail", tweet.getUser().getEmail());
        status.put("user.id", tweet.getUser().getId());
        status.put("user.location", tweet.getUser().getLocation());
        status.put("hashtags", hashtags);
        status.put("userMentions", userMentions);
        status.put("mediaUrls", mediaUrls);
        status.put("urls", urls);
        status.put("language", tweet.getLang());
        status.put("source", tweet.getSource());
        status.put("isRetweet", tweet.isRetweet());
        status.put("retweetCount", tweet.getRetweetCount());
        status.put("geoLocation", geoLocation);
        status.put("favouriteCount", tweet.getFavoriteCount());
        status.put("quotedStatusId", tweet.getQuotedStatusId());
        status.put("in.reply.to.status.id", tweet.getInReplyToStatusId());
        status.put("place.country", tweet.getPlace() == null ? "null" : tweet.getPlace().getCountry());
        status.put("place.country_code", tweet.getPlace() == null ? "null" : tweet.getPlace().getCountryCode());
        status.put("place.name", tweet.getPlace() == null ? "null" : tweet.getPlace().getName());
        status.put("place.id", tweet.getPlace() == null ? "null" : tweet.getPlace().getId());
        status.put("place.fullName", tweet.getPlace() == null ? "null" : tweet.getPlace().getFullName());
        status.put("track.words", trackwords);
        status.put("polling.query", query);
        return status;
    }
}

