/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.io.twitter.source;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.wso2.extension.siddhi.io.twitter.util.Util;
import org.wso2.siddhi.core.stream.input.source.SourceEventListener;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class TwitterPoller
implements Runnable {
    private static final Logger log = Logger.getLogger(TwitterPoller.class);
    private boolean paused;
    private boolean isKilled = false;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private Twitter twitter;
    private Query query;
    private QueryResult result;
    private SourceEventListener sourceEventListener;
    long tweetId = -1L;

    TwitterPoller(Twitter twitter, Query query, SourceEventListener sourceEventListener) {
        this.twitter = twitter;
        this.query = query;
        this.sourceEventListener = sourceEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isLatestId = true;
        do {
            try {
                if (this.isKilled) {
                    Thread.currentThread().interrupt();
                }
                this.result = this.twitter.search(this.query);
                List<Status> tweets = this.result.getTweets();
                for (Status tweet : tweets) {
                    Map<String, Object> event = Util.createMap(tweet);
                    if (isLatestId) {
                        this.tweetId = tweet.getId();
                        isLatestId = false;
                    }
                    if (this.paused) {
                        this.lock.lock();
                        try {
                            while (this.paused) {
                                this.condition.await();
                            }
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    this.sourceEventListener.onEvent(event, null);
                }
                if (this.result.nextQuery() != null) {
                    this.query = this.result.nextQuery();
                } else {
                    this.query.setSinceId(this.tweetId);
                    this.query.setMaxId(-1L);
                }
                this.checkRateLimit(this.result);
            }
            catch (TwitterException te) {
                log.error((Object)("Failed to search tweets: " + te.getMessage()));
            }
        } while (this.result.nextQuery() != null);
    }

    private void checkRateLimit(QueryResult result) {
        if (result.getRateLimitStatus().getRemaining() <= 0) {
            try {
                Thread.sleep(result.getRateLimitStatus().getSecondsUntilReset());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error((Object)("Thread was interrupted during wait : " + e));
            }
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void kill() {
        this.isKilled = true;
    }

    public void resume() {
        this.paused = false;
        try {
            this.lock.lock();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

