/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.map.xml.sourcemapper;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.stream.input.source.AttributeMapping;
import org.wso2.siddhi.core.stream.input.source.InputEventHandler;
import org.wso2.siddhi.core.stream.input.source.SourceMapper;
import org.wso2.siddhi.core.util.AttributeConverter;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="xml", namespace="sourceMapper", description="This mapper converts XML input to Siddhi event. Transports which accepts XML messages can utilize this extension to convert the incoming XML message to Siddhi event. Users can either send a pre-defined XML format where event conversion will happen without any configs or can use xpath to map from a custom XML message.", parameters={@Parameter(name="namespaces", description="Used to provide namespaces used in the incoming XML message beforehand to configure xpath expressions. User can provide a comma separated list. If these are not provided xpath evaluations will fail", type={DataType.STRING}, optional=true, defaultValue="None"), @Parameter(name="enclosing.element", description="Used to specify the enclosing element in case of sending multiple events in same XML message. WSO2 DAS will treat the child element of given enclosing element as events and execute xpath expressions on child elements. If enclosing.element is not provided multiple event scenario is disregarded and xpaths will be evaluated with respect to root element.", type={DataType.STRING}, optional=true, defaultValue="Root element"), @Parameter(name="fail.on.missing.attribute", description="This can either have value true or false. By default it will be true. This attribute allows user to handle unknown attributes. By default if an xpath execution fails or returns null DAS will drop that message. However setting this property to false will prompt DAS to send and event with null value to Siddhi where user can handle it accordingly(ie. Assign a default value)", type={DataType.BOOL}, optional=true, defaultValue="True")}, examples={@Example(syntax="@source(type='inMemory', topic='stock', @map(type='xml'))\ndefine stream FooStream (symbol string, price float, volume long);\n", description="Above configuration will do a default XML input mapping. Expected input will look like below.<events>\n    <event>\n        <symbol>WSO2</symbol>\n        <price>55.6</price>\n        <volume>100</volume>\n    </event>\n</events>\n"), @Example(syntax="@source(type='inMemory', topic='stock', @map(type='xml', namespaces = \"dt=urn:schemas-microsoft-com:datatypes\", enclosing.element=\"//portfolio\", @attributes(symbol = \"company/symbol\", price = \"price\", volume = \"volume\")))\ndefine stream FooStream (symbol string, price float, volume long);", description="Above configuration will perform a custom XML mapping. In the custom mapping user can add xpath expressions representing each event attribute using @attribute annotation. Expected input will look like below.\n<portfolio xmlns:dt=\"urn:schemas-microsoft-com:datatypes\">\n    <stock exchange=\"nasdaq\">\n        <volume>100</volume>\n        <company>\n           <symbol>WSO2</symbol>\n        </company>\n        <price dt:type=\"number\">55.6</price>\n    </stock>\n</portfolio>")})
public class XmlSourceMapper
extends SourceMapper {
    private static final Logger log = Logger.getLogger(XmlSourceMapper.class);
    private static final String PARENT_SELECTOR_XPATH = "enclosing.element";
    private static final String NAMESPACES = "namespaces";
    private static final String EVENTS_PARENT_ELEMENT = "events";
    private static final String EVENT_ELEMENT = "event";
    private static final String FAIL_ON_UNKNOWN_ATTRIBUTE = "fail.on.missing.attribute";
    private boolean isCustomMappingEnabled = false;
    private StreamDefinition streamDefinition;
    private AXIOMXPath enclosingElementSelectorPath = null;
    private Map<String, String> namespaceMap;
    private Map<String, AXIOMXPath> xPathMap = new HashMap<String, AXIOMXPath>();
    private boolean failOnUnknownAttribute;
    private AttributeConverter attributeConverter = new AttributeConverter();
    private List<Attribute> attributeList;
    private Map<String, Attribute.Type> attributeTypeMap = new HashMap<String, Attribute.Type>();
    private Map<String, Integer> attributePositionMap = new HashMap<String, Integer>();
    private List<AttributeMapping> attributeMappingList;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, List<AttributeMapping> attributeMappingList, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.attributeMappingList = attributeMappingList;
        this.attributeList = streamDefinition.getAttributeList();
        this.attributeTypeMap = new HashMap<String, Attribute.Type>(this.attributeList.size());
        this.attributePositionMap = new HashMap<String, Integer>(this.attributeList.size());
        this.namespaceMap = new HashMap<String, String>();
        for (Attribute attribute : this.attributeList) {
            this.attributeTypeMap.put(attribute.getName(), attribute.getType());
            this.attributePositionMap.put(attribute.getName(), streamDefinition.getAttributePosition(attribute.getName()));
        }
        this.failOnUnknownAttribute = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue(FAIL_ON_UNKNOWN_ATTRIBUTE, "true"));
        if (attributeMappingList == null || attributeMappingList.size() <= 0) return;
        this.isCustomMappingEnabled = true;
        if (streamDefinition.getAttributeList().size() < attributeMappingList.size()) {
            throw new SiddhiAppValidationException("Stream: '" + streamDefinition.getId() + "' has " + streamDefinition.getAttributeList().size() + " attributes, but " + attributeMappingList.size() + " attribute mappings found. Each attribute should have one and only one mapping.");
        }
        String namespaces = optionHolder.validateAndGetStaticValue(NAMESPACES, null);
        if (namespaces != null) {
            this.buildNamespaceMap(namespaces);
        }
        for (AttributeMapping attributeMapping : attributeMappingList) {
            AXIOMXPath axiomxPath;
            if (!this.attributeTypeMap.containsKey(attributeMapping.getName())) throw new SiddhiAppValidationException("No attribute with name " + attributeMapping.getName() + " available in stream. Hence halting Execution plan deployment");
            try {
                axiomxPath = new AXIOMXPath(attributeMapping.getMapping());
            }
            catch (JaxenException e) {
                throw new SiddhiAppValidationException("Error occurred when building XPath from: " + attributeMapping.getMapping() + ", mapped to attribute: " + attributeMapping.getName());
            }
            for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
                try {
                    axiomxPath.addNamespace(entry.getKey(), entry.getValue());
                }
                catch (JaxenException e) {
                    throw new SiddhiAppValidationException("Error occurred when adding namespace: " + entry.getKey() + ":" + entry.getValue() + " to XPath element: " + attributeMapping.getMapping());
                }
            }
            this.xPathMap.put(attributeMapping.getName(), axiomxPath);
        }
        String enclosingElementSelectorXPath = optionHolder.validateAndGetStaticValue(PARENT_SELECTOR_XPATH, null);
        if (enclosingElementSelectorXPath == null) return;
        try {
            this.enclosingElementSelectorPath = new AXIOMXPath(enclosingElementSelectorXPath);
            for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
                try {
                    this.enclosingElementSelectorPath.addNamespace(entry.getKey(), entry.getValue());
                }
                catch (JaxenException e) {
                    throw new SiddhiAppValidationException("Error occurred when adding namespace: " + entry.getKey() + ":" + entry.getValue() + " to XPath element:" + enclosingElementSelectorXPath);
                    return;
                }
            }
        }
        catch (JaxenException jaxenException) {
            throw new SiddhiAppRuntimeException("Could not get XPath from expression: " + enclosingElementSelectorXPath, (Throwable)jaxenException);
        }
    }

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{String.class, OMElement.class, byte[].class};
    }

    protected void mapAndProcess(Object eventObject, InputEventHandler inputEventHandler) throws InterruptedException {
        try {
            Event[] result = this.convertToEvents(eventObject);
            if (result.length > 0) {
                inputEventHandler.sendEvents(result);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Exception occurred when converting XML message to Siddhi Event", t);
        }
    }

    protected boolean allowNullInTransportProperties() {
        return !this.failOnUnknownAttribute;
    }

    private Event[] convertToEvents(Object eventObject) {
        OMElement rootOMElement;
        ArrayList<Event> eventList = new ArrayList<Event>();
        if (eventObject instanceof String) {
            try {
                rootOMElement = AXIOMUtil.stringToOM((String)((String)eventObject));
            }
            catch (XMLStreamException | DeferredParsingException e) {
                log.warn((Object)("Error parsing incoming XML event : " + eventObject + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                return new Event[0];
            }
        } else if (eventObject instanceof OMElement) {
            rootOMElement = (OMElement)eventObject;
        } else if (eventObject instanceof byte[]) {
            String events = null;
            try {
                events = new String((byte[])eventObject, "UTF-8");
                rootOMElement = AXIOMUtil.stringToOM((String)events);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error is encountered while decoding the byte stream. Please note that only UTF-8 encoding is supported" + e.getMessage()), (Throwable)e);
                return new Event[0];
            }
            catch (XMLStreamException | DeferredParsingException e) {
                log.warn((Object)("Error parsing incoming XML event : " + events + ". Reason: " + e.getMessage() + ". Hence dropping message chunk"));
                return new Event[0];
            }
        } else {
            log.warn((Object)("Event object is invalid. Expected String/OMElement or Byte Array, but found " + eventObject.getClass().getCanonicalName()));
            return new Event[0];
        }
        if (this.isCustomMappingEnabled) {
            if (this.enclosingElementSelectorPath != null) {
                List enclosingNodeList;
                try {
                    enclosingNodeList = this.enclosingElementSelectorPath.selectNodes((Object)rootOMElement);
                    if (enclosingNodeList.size() == 0) {
                        log.warn((Object)("Provided enclosing element did not match any xml node. Hence dropping the event :" + rootOMElement.toString()));
                        return new Event[0];
                    }
                }
                catch (JaxenException e) {
                    throw new SiddhiAppRuntimeException("Error occurred when selecting nodes from XPath: " + this.enclosingElementSelectorPath.toString(), (Throwable)e);
                }
                for (Object enclosingNode : enclosingNodeList) {
                    Iterator iterator = ((OMElement)enclosingNode).getChildElements();
                    while (iterator.hasNext()) {
                        OMElement eventOMElement = (OMElement)iterator.next();
                        Event event = this.buildEvent(eventOMElement);
                        if (event == null) continue;
                        eventList.add(event);
                    }
                }
            } else {
                Event event = this.buildEvent(rootOMElement);
                if (event != null) {
                    eventList.add(event);
                }
            }
        } else if (EVENTS_PARENT_ELEMENT.equals(rootOMElement.getLocalName())) {
            Iterator iterator = rootOMElement.getChildrenWithName(QName.valueOf(EVENT_ELEMENT));
            while (iterator.hasNext()) {
                boolean isMalformedEvent = false;
                OMElement eventOMElement = (OMElement)iterator.next();
                Event event = new Event(this.attributeList.size());
                Object[] data = event.getData();
                Iterator eventIterator = eventOMElement.getChildElements();
                while (eventIterator.hasNext()) {
                    OMElement attrOMElement = (OMElement)eventIterator.next();
                    String attributeName = attrOMElement.getLocalName();
                    Attribute.Type type = this.attributeTypeMap.get(attributeName);
                    if (type != null) {
                        try {
                            data[this.attributePositionMap.get((Object)attributeName).intValue()] = this.attributeConverter.getPropertyValue(attrOMElement.getText(), type);
                            continue;
                        }
                        catch (NumberFormatException | SiddhiAppRuntimeException e) {
                            log.warn((Object)("Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString()));
                            isMalformedEvent = true;
                            break;
                        }
                    }
                    log.warn((Object)("Attribute : " + attributeName + "was not found in given stream definition. " + "Hence ignoring this attribute"));
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null || !this.failOnUnknownAttribute) continue;
                    log.warn((Object)("No attribute with name: " + this.streamDefinition.getAttributeNameArray()[i] + " found in input event: " + eventOMElement.toString() + ". Hence dropping the" + " event."));
                    isMalformedEvent = true;
                }
                if (isMalformedEvent) continue;
                eventList.add(event);
            }
        } else {
            log.warn((Object)("Incoming XML message should adhere to pre-defined formatwhen using default mapping. Root element name should be events. But found " + rootOMElement.getLocalName() + ". Hence dropping XML message : " + rootOMElement.toString()));
        }
        return eventList.toArray(new Event[0]);
    }

    private void buildNamespaceMap(String namespace) {
        String[] namespaces;
        for (String ns : namespaces = namespace.split(",")) {
            String[] splits = ns.split("=");
            if (splits.length != 2) {
                log.warn((Object)("Malformed namespace mapping found: " + ns + ". Each namespace has to have format: " + "<prefix>=<uri>"));
            }
            this.namespaceMap.put(splits[0].trim(), splits[1].trim());
        }
    }

    private Event buildEvent(OMElement eventOMElement) {
        Event event = new Event(this.streamDefinition.getAttributeList().size());
        Object[] data = event.getData();
        for (AttributeMapping attributeMapping : this.attributeMappingList) {
            String attributeName = attributeMapping.getName();
            Attribute.Type attributeType = this.attributeTypeMap.get(attributeName);
            AXIOMXPath axiomXPath = this.xPathMap.get(attributeName);
            if (axiomXPath == null) continue;
            try {
                List selectedNodes = axiomXPath.selectNodes((Object)eventOMElement);
                if (selectedNodes.size() == 0) {
                    if (!this.failOnUnknownAttribute) continue;
                    log.warn((Object)("Xpath: '" + axiomXPath.toString() + " did not yield any results. Hence dropping " + "the event : " + eventOMElement.toString()));
                    return null;
                }
                Object elementObj = selectedNodes.get(0);
                if (elementObj instanceof OMElement) {
                    OMElement element = (OMElement)elementObj;
                    if (element.getFirstElement() != null) {
                        if (attributeType.equals((Object)Attribute.Type.STRING)) {
                            data[attributeMapping.getPosition()] = element.toString();
                            continue;
                        }
                        log.warn((Object)("XPath: " + axiomXPath.toString() + " did not return a leaf element and " + "stream definition is not expecting a String attribute. Hence " + "dropping the event: " + eventOMElement.toString()));
                        return null;
                    }
                    String attributeValue = element.getText();
                    try {
                        data[attributeMapping.getPosition()] = this.attributeConverter.getPropertyValue(attributeValue, attributeType);
                        continue;
                    }
                    catch (NumberFormatException | SiddhiAppRuntimeException e) {
                        if (!this.failOnUnknownAttribute) continue;
                        log.warn((Object)("Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString()));
                        return null;
                    }
                }
                if (!(elementObj instanceof OMAttribute)) continue;
                OMAttribute omAttribute = (OMAttribute)elementObj;
                try {
                    data[attributeMapping.getPosition()] = this.attributeConverter.getPropertyValue(omAttribute.getAttributeValue(), attributeType);
                }
                catch (NumberFormatException | SiddhiAppRuntimeException e) {
                    log.warn((Object)("Error occurred when extracting attribute value. Cause: " + e.getMessage() + ". Hence dropping the event: " + eventOMElement.toString()));
                    return null;
                }
            }
            catch (JaxenException e) {
                log.warn((Object)("Error occurred when selecting attribute: " + attributeName + " in the input event, using the given XPath: " + this.xPathMap.get(attributeName).toString()));
                return null;
            }
        }
        return event;
    }
}

