/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.listner;

import java.util.Set;
import org.wso2.carbon.identity.oauth.Error;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.IdentityOAuthClientException;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;

public class AppPortalOAuthAppMgtListener
implements OAuthApplicationMgtListener {
    private boolean enabled;
    private Set<String> systemAppConsumerKeys;

    public AppPortalOAuthAppMgtListener(boolean enabled) {
        this.enabled = enabled;
        this.systemAppConsumerKeys = AppsCommonDataHolder.getInstance().getSystemAppConsumerKeys();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getExecutionOrder() {
        return 1;
    }

    public void doPreUpdateConsumerApplication(OAuthConsumerAppDTO oAuthConsumerAppDTO) throws IdentityOAuthAdminException {
        block3: {
            block2: {
                if (!this.isEnabled()) break block2;
                if (!this.systemAppConsumerKeys.stream().noneMatch(oAuthConsumerAppDTO.getApplicationName()::equalsIgnoreCase)) break block3;
            }
            return;
        }
        throw new IdentityOAuthClientException(Error.INVALID_UPDATE.getErrorCode(), "System application update is not allowed. Client id: " + oAuthConsumerAppDTO.getOauthConsumerKey());
    }

    public void doPreUpdateConsumerApplicationState(String consumerKey, String newState) throws IdentityOAuthAdminException {
        block3: {
            block2: {
                if (!this.isEnabled()) break block2;
                if (!this.systemAppConsumerKeys.stream().noneMatch(consumerKey::equalsIgnoreCase)) break block3;
            }
            return;
        }
        throw new IdentityOAuthClientException(Error.INVALID_UPDATE.getErrorCode(), "Changing state of system application is not allowed. Client id: " + consumerKey);
    }

    public void doPreRemoveOAuthApplicationData(String consumerKey) throws IdentityOAuthAdminException {
        block3: {
            block2: {
                if (!this.isEnabled()) break block2;
                if (!this.systemAppConsumerKeys.stream().noneMatch(consumerKey::equalsIgnoreCase)) break block3;
            }
            return;
        }
        throw new IdentityOAuthClientException(Error.INVALID_DELETE.getErrorCode(), "System application deletion is not allowed. Client id: " + consumerKey);
    }
}

