/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.listner;

import java.util.Set;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementClientException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.oauth.Error;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;

public class AppPortalApplicationMgtListener
extends AbstractApplicationMgtListener {
    private boolean enable;
    private Set<String> systemApplications;

    public AppPortalApplicationMgtListener(boolean enable) {
        this.enable = enable;
        this.systemApplications = AppsCommonDataHolder.getInstance().getSystemApplications();
    }

    public int getDefaultOrderId() {
        return 30;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean doPreUpdateApplication(ServiceProvider serviceProvider, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ServiceProvider existingApplication;
        block5: {
            block4: {
                if (!this.isEnable() || !"carbon.super".equals(tenantDomain)) {
                    return true;
                }
                existingApplication = this.getApplicationByResourceId(serviceProvider.getApplicationResourceId(), tenantDomain);
                if (existingApplication == null) break block4;
                if (!this.systemApplications.stream().noneMatch(existingApplication.getApplicationName()::equalsIgnoreCase)) break block5;
            }
            return true;
        }
        throw new IdentityApplicationManagementClientException(Error.INVALID_UPDATE.getErrorCode(), "Update of system applications are not allowed. Application name: " + existingApplication.getApplicationName());
    }

    public boolean doPreDeleteApplication(String applicationName, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        block3: {
            block2: {
                if (!this.isEnable() || !"carbon.super".equals(tenantDomain)) break block2;
                if (!this.systemApplications.stream().noneMatch(applicationName::equalsIgnoreCase)) break block3;
            }
            return true;
        }
        throw new IdentityApplicationManagementClientException(Error.INVALID_DELETE.getErrorCode(), "Deletion of system applications are not allowed. Application name: " + applicationName);
    }

    private ServiceProvider getApplicationByResourceId(String resourceId, String tenantDomain) throws IdentityApplicationManagementException {
        return AppsCommonDataHolder.getInstance().getApplicationManagementService().getApplicationByResourceId(resourceId, tenantDomain);
    }
}

