/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.identity.apps.common.internal;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.InboundAuthenticationRequestConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthAdminServiceImpl;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.organization.management.service.OrganizationManagementInitialize;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.identity.apps.common.internal.AppsCommonDataHolder;
import org.wso2.identity.apps.common.listner.AppPortalApplicationMgtListener;
import org.wso2.identity.apps.common.listner.AppPortalOAuthAppMgtListener;
import org.wso2.identity.apps.common.util.AppPortalConstants;
import org.wso2.identity.apps.common.util.AppPortalUtils;

@Component(name="org.wso2.identity.apps.common.AppsCommonServiceComponent", immediate=true, property={"componentName=identity-apps-common"})
public class AppsCommonServiceComponent {
    private static Log log = LogFactory.getLog(AppsCommonServiceComponent.class);

    @Activate
    protected void activate(BundleContext bundleContext) {
        try {
            Set<String> systemApplications;
            if (this.skipPortalInitialization()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Portal application initialization is skipped.");
                }
            } else {
                AppPortalUtils.initiatePortals("carbon.super", -1234);
            }
            if (!(systemApplications = this.getSystemApplications()).isEmpty()) {
                AppsCommonDataHolder.getInstance().setSystemApplications(systemApplications);
                Set<String> systemAppConsumerKeys = this.getSystemAppConsumerKeys(systemApplications);
                if (!systemAppConsumerKeys.isEmpty()) {
                    AppsCommonDataHolder.getInstance().setSystemAppConsumerKeys(systemAppConsumerKeys);
                }
                AppPortalOAuthAppMgtListener oAuthApplicationMgtListener = new AppPortalOAuthAppMgtListener(true);
                bundleContext.registerService(OAuthApplicationMgtListener.class.getName(), (Object)oAuthApplicationMgtListener, null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"AppPortalOAuthAppMgtListener registered successfully.");
                }
                AppPortalApplicationMgtListener applicationMgtListener = new AppPortalApplicationMgtListener(true);
                bundleContext.registerService(ApplicationMgtListener.class.getName(), (Object)applicationMgtListener, null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"AppPortalApplicationMgtListener registered successfully.");
                }
            }
            for (AppPortalConstants.AppPortal appPortal : AppPortalConstants.AppPortal.values()) {
                log.info((Object)(appPortal.getName() + " URL : " + IdentityUtil.getServerURL((String)appPortal.getEndpoint(), (boolean)true, (boolean)true)));
            }
            log.info((Object)"Identity apps common service component activated successfully.");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate identity apps common service component.", e);
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service.");
        }
        AppsCommonDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Registry Service.");
        }
        AppsCommonDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="application.mgt.service", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationManagementService")
    protected void setApplicationManagementService(ApplicationManagementService applicationManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Application Management Service.");
        }
        AppsCommonDataHolder.getInstance().setApplicationManagementService(applicationManagementService);
    }

    protected void unsetApplicationManagementService(ApplicationManagementService applicationManagementService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the Application Management Service.");
        }
        AppsCommonDataHolder.getInstance().setApplicationManagementService(null);
    }

    @Reference(name="oauth.admin.service", service=OAuthAdminServiceImpl.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetOAuthAdminService")
    protected void setOAuthAdminService(OAuthAdminServiceImpl oAuthAdminService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the OAuth Admin Service.");
        }
        AppsCommonDataHolder.getInstance().setOAuthAdminService(oAuthAdminService);
    }

    protected void unsetOAuthAdminService(OAuthAdminServiceImpl oAuthAdminService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the OAuth Admin Service.");
        }
        AppsCommonDataHolder.getInstance().setOAuthAdminService(null);
    }

    @Reference(name="identity.core.init.event.service", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="carbon.sso.session.manager.service", service=CarbonSSOSessionManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonSSOSessionManager")
    protected void setCarbonSSOSessionManager(CarbonSSOSessionManager carbonSSOSessionManager) {
    }

    protected void unsetCarbonSSOSessionManager(CarbonSSOSessionManager carbonSSOSessionManager) {
    }

    @Reference(name="organization.mgt.initialize.service", service=OrganizationManagementInitialize.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetOrganizationManagementEnablingService")
    protected void setOrganizationManagementEnablingService(OrganizationManagementInitialize organizationManagementInitializeService) {
        AppsCommonDataHolder.getInstance().setOrganizationManagementEnable(organizationManagementInitializeService);
    }

    protected void unsetOrganizationManagementEnablingService(OrganizationManagementInitialize organizationManagementInitializeInstance) {
        AppsCommonDataHolder.getInstance().setOrganizationManagementEnable(null);
    }

    private boolean skipPortalInitialization() {
        return System.getProperty("skipServerInitialization") != null;
    }

    private Set<String> getSystemApplications() {
        return AppsCommonDataHolder.getInstance().getApplicationManagementService().getSystemApplications();
    }

    private Set<String> getSystemAppConsumerKeys(Set<String> systemApplications) throws IdentityApplicationManagementException {
        HashSet<String> systemAppConsumerKeys = new HashSet<String>();
        for (String applicationName : systemApplications) {
            InboundAuthenticationRequestConfig inboundAuthenticationRequestConfig;
            ServiceProvider systemApplication = AppsCommonDataHolder.getInstance().getApplicationManagementService().getApplicationExcludingFileBasedSPs(applicationName, "carbon.super");
            if (systemApplication == null || (inboundAuthenticationRequestConfig = AppPortalUtils.getOAuthInboundAuthenticationRequestConfig(systemApplication)) == null || !StringUtils.isNotBlank((String)inboundAuthenticationRequestConfig.getInboundAuthKey())) continue;
            systemAppConsumerKeys.add(inboundAuthenticationRequestConfig.getInboundAuthKey());
        }
        return systemAppConsumerKeys;
    }
}

