/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.okta.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.okta.client.FormEncoder;
import org.wso2.okta.client.model.AccessTokenInfo;
import org.wso2.okta.client.model.ClientInfo;
import org.wso2.okta.client.model.IntrospectClient;
import org.wso2.okta.client.model.IntrospectInfo;
import org.wso2.okta.client.model.JWKS;
import org.wso2.okta.client.model.OKtaAPIKeyInterceptor;
import org.wso2.okta.client.model.OktaDCRClient;

public class OktaOAuthClient
extends AbstractKeyManager {
    private static final Log log = LogFactory.getLog(OktaOAuthClient.class);
    private OktaDCRClient oktaDCRClient;
    private IntrospectClient introspectClient;

    public void loadConfiguration(KeyManagerConfiguration keyManagerConfiguration) throws APIManagementException {
        this.configuration = keyManagerConfiguration;
        String clientRegistrationEndpoint = (String)this.configuration.getParameter("client_registration_endpoint");
        String apiKey = (String)this.configuration.getParameter("apiKey");
        this.oktaDCRClient = (OktaDCRClient)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)new OKtaAPIKeyInterceptor(apiKey)).target(OktaDCRClient.class, clientRegistrationEndpoint);
        String introspectEndpoint = (String)this.configuration.getParameter("introspection_endpoint");
        String clientId = (String)this.configuration.getParameter("client_id");
        String clientSecret = (String)this.configuration.getParameter("client_secret");
        this.introspectClient = (IntrospectClient)Feign.builder().client((Client)new OkHttpClient()).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(clientId, clientSecret)).encoder((Encoder)new FormEncoder()).target(IntrospectClient.class, introspectEndpoint);
    }

    public OAuthApplicationInfo createApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        ClientInfo clientInfo = this.createClientInfoFromOauthApplicationInfo(oAuthApplicationInfo);
        ClientInfo createdApplication = this.oktaDCRClient.createApplication(clientInfo);
        if (createdApplication != null) {
            oAuthApplicationInfo = this.createOAuthAppInfoFromResponse(createdApplication);
            return oAuthApplicationInfo;
        }
        return null;
    }

    public OAuthApplicationInfo updateApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        ClientInfo clientInfo = this.createClientInfoFromOauthApplicationInfo(oAuthApplicationInfo);
        String clientId = oAuthApplicationInfo.getClientId();
        ClientInfo clientInfoFromOkta = this.oktaDCRClient.getApplication(clientId);
        if (clientInfoFromOkta != null && clientInfoFromOkta.getApplicationType().equals(clientInfo.getApplicationType())) {
            ClientInfo updatedClientInfo = this.oktaDCRClient.updateApplication(clientId, clientInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Updating an OAuth client in Okta authorization server for the Consumer Key %s", clientId));
            }
            return this.createOAuthAppInfoFromResponse(updatedClientInfo);
        }
        throw new APIManagementException("Error occured while updating Oauth Client in Okta Authorization server due to read-only attribute change");
    }

    public OAuthApplicationInfo updateApplicationOwner(OAuthAppRequest appInfoDTO, String owner) throws APIManagementException {
        return appInfoDTO.getOAuthApplicationInfo();
    }

    public void deleteApplication(String clientId) throws APIManagementException {
        this.oktaDCRClient.deleteApplication(clientId);
    }

    public OAuthApplicationInfo retrieveApplication(String clientId) throws APIManagementException {
        ClientInfo retrievedClientInfo = this.oktaDCRClient.getApplication(clientId);
        return this.createOAuthAppInfoFromResponse(retrievedClientInfo);
    }

    public org.wso2.carbon.apimgt.api.model.AccessTokenInfo getNewApplicationAccessToken(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        org.wso2.carbon.apimgt.api.model.AccessTokenInfo tokenInfo = new org.wso2.carbon.apimgt.api.model.AccessTokenInfo();
        String clientId = accessTokenRequest.getClientId();
        String clientSecret = accessTokenRequest.getClientSecret();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Get new client access token from authorization server for the Consumer Key %s", clientId));
        }
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String grantType = accessTokenRequest.getGrantType();
        if (grantType == null) {
            grantType = "client_credentials";
        }
        parameters.add((NameValuePair)new BasicNameValuePair("grant_type", grantType));
        String scopeString = OktaOAuthClient.convertToString(accessTokenRequest.getScope());
        if (StringUtils.isEmpty((String)scopeString)) {
            parameters.add((NameValuePair)new BasicNameValuePair("scope", (String)this.configuration.getParameter("defaultScope")));
        } else {
            parameters.add((NameValuePair)new BasicNameValuePair("scope", scopeString));
        }
        AccessTokenInfo accessToken = this.getAccessToken(clientId, clientSecret, parameters);
        if (accessToken != null) {
            this.updateTokenInfo(tokenInfo, accessToken);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("OAuth token has been successfully validated for the Consumer Key %s", clientId));
            }
            return tokenInfo;
        }
        tokenInfo.setTokenValid(false);
        tokenInfo.setErrorcode(900901);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("OAuth token validation failed for the Consumer Key %s", clientId));
        }
        return tokenInfo;
    }

    public AccessTokenRequest buildAccessTokenRequestFromOAuthApp(OAuthApplicationInfo oAuthApplication, AccessTokenRequest tokenRequest) throws APIManagementException {
        Object grantType;
        log.debug((Object)"Invoking buildAccessTokenRequestFromOAuthApp() method..");
        if (oAuthApplication == null) {
            return tokenRequest;
        }
        if (tokenRequest == null) {
            tokenRequest = new AccessTokenRequest();
        }
        String clientName = oAuthApplication.getClientName();
        if (oAuthApplication.getClientId() == null) {
            throw new APIManagementException(String.format("Consumer key is missing for the Application: %s", clientName));
        }
        if (oAuthApplication.getClientSecret() == null) {
            log.error((Object)String.format("Consumer Secret is missing for the Application: %s", clientName));
        }
        tokenRequest.setClientId(oAuthApplication.getClientId());
        tokenRequest.setClientSecret(oAuthApplication.getClientSecret());
        if (oAuthApplication.getParameter("tokenScope") != null) {
            Object[] tokenScopes = null;
            if (oAuthApplication.getParameter("tokenScope") instanceof String[]) {
                tokenScopes = (String[])oAuthApplication.getParameter("tokenScope");
            }
            if (oAuthApplication.getParameter("tokenScope") instanceof String) {
                tokenScopes = oAuthApplication.getParameter("tokenScope").toString().split(",");
            }
            tokenRequest.setScope((String[])tokenScopes);
            oAuthApplication.addParameter("tokenScope", (Object)Arrays.toString(tokenScopes));
        }
        if (oAuthApplication.getParameter("validityPeriod") != null) {
            tokenRequest.setValidityPeriod(Long.parseLong((String)oAuthApplication.getParameter("validityPeriod")));
        }
        if ((grantType = oAuthApplication.getParameter("tokenGrantType")) != null) {
            tokenRequest.setGrantType((String)grantType);
        }
        return tokenRequest;
    }

    public org.wso2.carbon.apimgt.api.model.AccessTokenInfo getTokenMetaData(String accessToken) throws APIManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Getting access token metadata from authorization server. Access token %s", accessToken));
        }
        org.wso2.carbon.apimgt.api.model.AccessTokenInfo tokenInfo = new org.wso2.carbon.apimgt.api.model.AccessTokenInfo();
        IntrospectInfo introspectInfo = this.introspectClient.introspect(accessToken, "access_token");
        tokenInfo.setTokenValid(introspectInfo.isActive());
        if (tokenInfo.isTokenValid()) {
            long expiryTime = introspectInfo.getExpiry() * 1000L;
            long issuedTime = introspectInfo.getIssuedAt() * 1000L;
            tokenInfo.setValidityPeriod(expiryTime - issuedTime);
            if (StringUtils.isNotEmpty((String)introspectInfo.getScope())) {
                tokenInfo.setScope(introspectInfo.getScope().split("\\s+"));
            }
            tokenInfo.setIssuedTime(issuedTime);
            tokenInfo.setConsumerKey(introspectInfo.getClientId());
            tokenInfo.setEndUserName(introspectInfo.getSub());
            tokenInfo.addParameter("sub", (Object)introspectInfo.getSub());
            tokenInfo.addParameter("aud", (Object)introspectInfo.getAudience());
            tokenInfo.addParameter("iss", (Object)introspectInfo.getAudience());
            tokenInfo.addParameter("token_type", (Object)introspectInfo.getTokenType());
            tokenInfo.addParameter("uid", (Object)introspectInfo.getUid());
            tokenInfo.addParameter("jti", (Object)introspectInfo.getJti());
            return tokenInfo;
        }
        return null;
    }

    public KeyManagerConfiguration getKeyManagerConfiguration() throws APIManagementException {
        return this.configuration;
    }

    public OAuthApplicationInfo buildFromJSON(String s) throws APIManagementException {
        return null;
    }

    public OAuthApplicationInfo mapOAuthApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        return oAuthAppRequest.getOAuthApplicationInfo();
    }

    public boolean registerNewResource(API api, Map resourceAttributes) throws APIManagementException {
        return true;
    }

    public Map getResourceByApiId(String apiId) throws APIManagementException {
        return null;
    }

    public boolean updateRegisteredResource(API api, Map resourceAttributes) throws APIManagementException {
        return true;
    }

    public void deleteRegisteredResourceByAPIId(String apiID) throws APIManagementException {
    }

    public void deleteMappedApplication(String clientId) throws APIManagementException {
    }

    public Set<String> getActiveTokensByConsumerKey(String s) throws APIManagementException {
        return Collections.emptySet();
    }

    public org.wso2.carbon.apimgt.api.model.AccessTokenInfo getAccessTokenByConsumerKey(String s) throws APIManagementException {
        return null;
    }

    private ClientInfo createClientInfoFromOauthApplicationInfo(OAuthApplicationInfo oAuthApplicationInfo) throws APIManagementException {
        ClientInfo clientInfo = new ClientInfo();
        String userId = (String)oAuthApplicationInfo.getParameter("username");
        String userNameForSp = MultitenantUtils.getTenantAwareUsername((String)userId);
        String domain = UserCoreUtil.extractDomainFromName((String)userNameForSp);
        if (domain != null && !domain.isEmpty() && !"PRIMARY".equals(domain)) {
            userNameForSp = userNameForSp.replace(UserCoreConstants.DOMAIN_SEPARATOR, "_");
        }
        String applicationName = oAuthApplicationInfo.getClientName();
        String keyType = (String)oAuthApplicationInfo.getParameter("key_type");
        String callBackURL = oAuthApplicationInfo.getCallBackURL();
        if (keyType != null) {
            applicationName = userNameForSp.concat(applicationName).concat("_").concat(keyType);
        }
        List<Object> grantTypes = new ArrayList();
        if (oAuthApplicationInfo.getParameter("grant_types") != null) {
            grantTypes = Arrays.asList(((String)oAuthApplicationInfo.getParameter("grant_types")).split(","));
        }
        Object parameter = oAuthApplicationInfo.getParameter("additionalProperties");
        Map additionalProperties = new HashMap();
        if (parameter instanceof String) {
            additionalProperties = (Map)new Gson().fromJson((String)parameter, Map.class);
        }
        clientInfo.setClientName(applicationName);
        if (grantTypes != null && !grantTypes.isEmpty()) {
            clientInfo.setGrantTypes(grantTypes);
        }
        if (StringUtils.isNotEmpty((String)callBackURL)) {
            String[] calBackUris = callBackURL.split(",");
            clientInfo.setRedirectUris(Arrays.asList(calBackUris));
        }
        if (additionalProperties.containsKey("application_type")) {
            clientInfo.setApplicationType((String)additionalProperties.get("application_type"));
        }
        if (additionalProperties.containsKey("initiate_login_uri")) {
            clientInfo.setLoginInitiationUri((String)additionalProperties.get("initiate_login_uri"));
        }
        if (additionalProperties.containsKey("client_id")) {
            clientInfo.setClientId((String)additionalProperties.get("client_id"));
        }
        if (additionalProperties.containsKey("client_secret")) {
            clientInfo.setClientSecret((String)additionalProperties.get("client_secret"));
        }
        if (additionalProperties.containsKey("client_uri")) {
            clientInfo.setClientUri((String)additionalProperties.get("client_uri"));
        }
        if (additionalProperties.containsKey("logo_uri")) {
            clientInfo.setLogoUri((String)additionalProperties.get("logo_uri"));
        }
        if (additionalProperties.containsKey("post_logout_redirect_uris")) {
            clientInfo.setLogoutRedirectUris((List)additionalProperties.get("post_logout_redirect_uris"));
        }
        if (additionalProperties.containsKey("response_types")) {
            clientInfo.setResponseTypes((List)additionalProperties.get("response_types"));
        }
        if (additionalProperties.containsKey("token_endpoint_auth_method")) {
            clientInfo.setTokenEndpointAuthMethod((String)additionalProperties.get("token_endpoint_auth_method"));
        }
        if (additionalProperties.containsKey("tos_uri")) {
            clientInfo.setTosUri((String)additionalProperties.get("tos_uri"));
        }
        if (additionalProperties.containsKey("policy_uri")) {
            clientInfo.setPolicyUri((String)additionalProperties.get("policy_uri"));
        }
        if (additionalProperties.containsKey("request_object_signing_alg")) {
            clientInfo.setRequestObjectSigningAlgorithm((String)additionalProperties.get("request_object_signing_alg"));
        }
        if (additionalProperties.containsKey("jwks")) {
            Map jwksValue = (Map)additionalProperties.get("jwks");
            JsonElement jsonObject = new Gson().toJsonTree((Object)jwksValue);
            JWKS jwks = (JWKS)new Gson().fromJson(jsonObject, JWKS.class);
            clientInfo.setJwks(jwks);
        }
        return clientInfo;
    }

    private OAuthApplicationInfo createOAuthAppInfoFromResponse(ClientInfo clientInfo) {
        OAuthApplicationInfo appInfo = new OAuthApplicationInfo();
        appInfo.setClientName(clientInfo.getClientName());
        appInfo.setClientId(clientInfo.getClientId());
        appInfo.setClientSecret(clientInfo.getClientSecret());
        if (clientInfo.getRedirectUris() != null) {
            appInfo.setCallBackURL(String.join((CharSequence)",", clientInfo.getRedirectUris()));
        }
        if (clientInfo.getGrantTypes() != null) {
            appInfo.addParameter("grant_types", (Object)String.join((CharSequence)" ", clientInfo.getGrantTypes()));
        }
        if (StringUtils.isNotEmpty((String)clientInfo.getClientName())) {
            appInfo.addParameter("client_name", (Object)clientInfo.getClientName());
        }
        if (StringUtils.isNotEmpty((String)clientInfo.getClientId())) {
            appInfo.addParameter("client_id", (Object)clientInfo.getClientId());
        }
        if (StringUtils.isNotEmpty((String)clientInfo.getClientSecret())) {
            appInfo.addParameter("client_secret", (Object)clientInfo.getClientSecret());
        }
        String additionalProperties = new Gson().toJson((Object)clientInfo);
        appInfo.addParameter("additionalProperties", new Gson().fromJson(additionalProperties, Map.class));
        return appInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private AccessTokenInfo getAccessToken(String clientId, String clientSecret, List<NameValuePair> parameters) throws APIManagementException {
        block33: {
            try {
                Throwable throwable = null;
                try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
                    String tokenEndpoint = (String)this.configuration.getParameter("token_endpoint");
                    HttpPost httpPost = new HttpPost(tokenEndpoint);
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
                    String encodedCredentials = OktaOAuthClient.getEncodedCredentials(clientId, clientSecret);
                    httpPost.setHeader("Authorization", "Basic " + encodedCredentials);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Invoking HTTP request to get the accesstoken.");
                    }
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    int statusCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        OktaOAuthClient.handleException(String.format("%s %s", "Could not read http entity for response", response));
                    }
                    if (200 == statusCode) {
                        try (InputStream inputStream = entity.getContent();){
                            String content = IOUtils.toString((InputStream)inputStream);
                            AccessTokenInfo accessTokenInfo = (AccessTokenInfo)new Gson().fromJson(content, AccessTokenInfo.class);
                            return accessTokenInfo;
                        }
                    }
                    break block33;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                this.handleException("Encoding method is not supported", e);
            }
            catch (IOException e) {
                this.handleException("Error has occurred while reading or closing buffer reader", e);
            }
        }
        return null;
    }

    private org.wso2.carbon.apimgt.api.model.AccessTokenInfo updateTokenInfo(org.wso2.carbon.apimgt.api.model.AccessTokenInfo tokenInfo, AccessTokenInfo accessToken) {
        tokenInfo.setAccessToken(accessToken.getAccessToken());
        tokenInfo.setValidityPeriod(accessToken.getExpiry() * 1000L);
        tokenInfo.setScope(accessToken.getScope().split("\\s+"));
        return tokenInfo;
    }

    private static String convertToString(String[] stringArray) {
        if (stringArray != null) {
            StringBuilder sb = new StringBuilder();
            List<String> strList = Arrays.asList(stringArray);
            for (String s : strList) {
                sb.append(s);
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return null;
    }

    private static String getEncodedCredentials(String clientId, String clientSecret) throws APIManagementException {
        String encodedCredentials;
        try {
            encodedCredentials = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new APIManagementException("Encoding method is not supported", (Throwable)e);
        }
        return encodedCredentials;
    }

    private static void handleException(String msg) throws APIManagementException {
        log.error((Object)msg);
        throw new APIManagementException(msg);
    }

    public String getNewApplicationConsumerSecret(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        ClientInfo clientInfo = this.oktaDCRClient.regenerateClientSecret(accessTokenRequest.getClientId());
        return clientInfo.getClientSecret();
    }

    public Map<String, Set<Scope>> getScopesForAPIS(String apiIdsString) throws APIManagementException {
        HashMap<String, Set<Scope>> apiToScopeMapping = new HashMap<String, Set<Scope>>();
        ApiMgtDAO apiMgtDAO = ApiMgtDAO.getInstance();
        Map apiToScopeKeyMapping = apiMgtDAO.getScopesForAPIS(apiIdsString);
        for (String apiId : apiToScopeKeyMapping.keySet()) {
            LinkedHashSet<Scope> apiScopes = new LinkedHashSet<Scope>();
            Set scopeKeys = (Set)apiToScopeKeyMapping.get(apiId);
            for (String scopeKey : scopeKeys) {
                Scope scope = this.getScopeByName(scopeKey);
                apiScopes.add(scope);
            }
            apiToScopeMapping.put(apiId, apiScopes);
        }
        return apiToScopeMapping;
    }

    public void registerScope(Scope scope) throws APIManagementException {
    }

    public Scope getScopeByName(String name) throws APIManagementException {
        return null;
    }

    public Map<String, Scope> getAllScopes() throws APIManagementException {
        return null;
    }

    public void attachResourceScopes(API api, Set<URITemplate> uriTemplates) throws APIManagementException {
    }

    public void updateResourceScopes(API api, Set<String> oldLocalScopeKeys, Set<Scope> newLocalScopes, Set<URITemplate> oldURITemplates, Set<URITemplate> newURITemplates) throws APIManagementException {
    }

    public void detachResourceScopes(API api, Set<URITemplate> uriTemplates) throws APIManagementException {
    }

    public void deleteScope(String scopeName) throws APIManagementException {
    }

    public void updateScope(Scope scope) throws APIManagementException {
    }

    public boolean isScopeExists(String scopeName) throws APIManagementException {
        return false;
    }

    public void validateScopes(Set<Scope> scopes) throws APIManagementException {
    }

    public String getType() {
        return "Okta";
    }
}

