/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.okta.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.KeyManagerConnectorConfiguration;
import org.wso2.okta.client.OktaOAuthClient;

@Component(name="okta.configuration.component", immediate=true, service={KeyManagerConnectorConfiguration.class})
public class OKTAConnectorConfiguration
implements KeyManagerConnectorConfiguration {
    public String getImplementation() {
        return OktaOAuthClient.class.getName();
    }

    public String getJWTValidator() {
        return null;
    }

    public List<ConfigurationDto> getConnectionConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("apiKey", "API KEY", "input", "API Key Generated From Okta UI", (Object)"", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("client_id", "Client ID", "input", "Client ID of service Application", (Object)"", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("client_secret", "Client Secret", "input", "Client Secret of service Application", (Object)"", true, true, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public List<ConfigurationDto> getApplicationConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("application_type", "Application Type", "select", "Type Of Application to create", (Object)"web", false, false, Arrays.asList("web", "native", "service", "browser"), false));
        configurationDtoList.add(new ConfigurationDto("response_types", "Response Type", "select", "Type Of Token response", (Object)"", true, false, Arrays.asList("code", "token", "id_token"), true));
        configurationDtoList.add(new ConfigurationDto("token_endpoint_auth_method", "Token endpoint Authentication Method", "select", "How to Authenticate Token Endpoint", (Object)"client_secret_basic", true, true, Arrays.asList("client_secret_basic", "client_secret_post", "client_secret_jwt"), false));
        return configurationDtoList;
    }

    public String getType() {
        return "Okta";
    }

    public String getDefaultScopesClaim() {
        return "scp";
    }

    public String getDefaultConsumerKeyClaim() {
        return "cid";
    }
}

