/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.okta.client;

import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.impl.kmclient.KeyManagerClientException;

public class OktaErrorDecoder
implements ErrorDecoder {
    public Exception decode(String s, Response response) {
        String errorDescription = this.getErrorDescriptionFromStream(response);
        if (StringUtils.isEmpty((String)errorDescription)) {
            errorDescription = response.reason();
        }
        if (response.status() >= 400 && response.status() <= 499 || response.status() >= 500 && response.status() <= 599) {
            return new KeyManagerClientException(response.status(), errorDescription);
        }
        return FeignException.errorStatus((String)s, (Response)response);
    }

    private String getErrorDescriptionFromStream(Response response) {
        String errorDescription = null;
        if (response.body() != null) {
            try {
                String responseStr = IOUtils.toString((InputStream)response.body().asInputStream(), (Charset)StandardCharsets.UTF_8);
                JSONParser jsonParser = new JSONParser();
                JSONObject responseJson = (JSONObject)jsonParser.parse(responseStr);
                Object errorObj = responseJson.get((Object)"error_description");
                if (errorObj != null) {
                    errorDescription = errorObj.toString();
                }
            }
            catch (IOException | ParseException throwable) {
                // empty catch block
            }
        }
        return errorDescription;
    }
}

