/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.pingfederate.client;

import com.google.gson.Gson;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.Response;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.AccessTokenRequest;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.impl.AbstractKeyManager;
import org.wso2.carbon.apimgt.impl.kmclient.ApacheFeignHttpClient;
import org.wso2.carbon.apimgt.impl.kmclient.FormEncoder;
import org.wso2.carbon.apimgt.impl.kmclient.KMClientErrorDecoder;
import org.wso2.carbon.apimgt.impl.kmclient.KeyManagerClientException;
import org.wso2.carbon.apimgt.impl.kmclient.model.AuthClient;
import org.wso2.carbon.apimgt.impl.kmclient.model.TokenInfo;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.pingfederate.model.ClientInfo;
import org.wso2.pingfederate.model.ClientInfoList;
import org.wso2.pingfederate.model.IntrospectClient;
import org.wso2.pingfederate.model.IntrospectInfo;
import org.wso2.pingfederate.model.PingFederateDCRClient;

public class PingFederatKeyManagerClient
extends AbstractKeyManager {
    private static final Log log = LogFactory.getLog(PingFederatKeyManagerClient.class);
    private PingFederateDCRClient pingFederateDCRClient;
    private IntrospectClient introspectionClient;
    private AuthClient authClient;

    public OAuthApplicationInfo createApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        ClientInfo clientInfo = this.fromOauthAppRequestToClientInfo(oAuthAppRequest);
        Response response = this.pingFederateDCRClient.createApplication(this.toClientInfoList(clientInfo));
        if (response.status() == 200) {
            log.debug((Object)"Application created in PINGFederate");
            return this.fromClientInfoToOauthApplicationInfo(clientInfo);
        }
        throw new APIManagementException("Error while creating Oauth Application in PingFederate Server");
    }

    private OAuthApplicationInfo fromClientInfoToOauthApplicationInfo(ClientInfo clientInfo) {
        OAuthApplicationInfo appInfo = new OAuthApplicationInfo();
        appInfo.setClientName(clientInfo.getName());
        appInfo.setClientId(clientInfo.getClientId());
        appInfo.setClientSecret(clientInfo.getSecret());
        if (clientInfo.getRedirectUris() != null) {
            appInfo.setCallBackURL(String.join((CharSequence)",", clientInfo.getRedirectUris()));
        }
        if (clientInfo.getGrantTypes() != null) {
            appInfo.addParameter("grant_types", (Object)String.join((CharSequence)" ", clientInfo.getGrantTypes()));
        }
        if (StringUtils.isNotEmpty((String)clientInfo.getName())) {
            appInfo.addParameter("client_name", (Object)clientInfo.getName());
        }
        if (StringUtils.isNotEmpty((String)clientInfo.getClientId())) {
            appInfo.addParameter("client_id", (Object)clientInfo.getClientId());
        }
        if (StringUtils.isNotEmpty((String)clientInfo.getSecret())) {
            appInfo.addParameter("client_secret", (Object)clientInfo.getSecret());
        }
        String additionalProperties = new Gson().toJson((Object)clientInfo);
        appInfo.addParameter("additionalProperties", new Gson().fromJson(additionalProperties, Map.class));
        return appInfo;
    }

    private ClientInfoList toClientInfoList(ClientInfo clientInfo) {
        ClientInfoList clientInfoList = new ClientInfoList();
        clientInfoList.getClients().add(clientInfo);
        return clientInfoList;
    }

    private ClientInfo fromOauthAppRequestToClientInfo(OAuthAppRequest oAuthAppRequest) {
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setClientAuthnType("SECRET");
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        String userId = (String)oAuthApplicationInfo.getParameter("username");
        String userNameForSp = MultitenantUtils.getTenantAwareUsername((String)userId);
        String domain = UserCoreUtil.extractDomainFromName((String)userNameForSp);
        if (domain != null && !domain.isEmpty() && !"PRIMARY".equals(domain)) {
            userNameForSp = userNameForSp.replace(UserCoreConstants.DOMAIN_SEPARATOR, "_");
        }
        String applicationName = oAuthApplicationInfo.getClientName();
        String keyType = (String)oAuthApplicationInfo.getParameter("key_type");
        String callBackURL = oAuthApplicationInfo.getCallBackURL();
        if (keyType != null) {
            applicationName = userNameForSp.concat(applicationName).concat("_").concat(keyType);
        }
        List<Object> grantTypes = new ArrayList();
        if (oAuthApplicationInfo.getParameter("grant_types") != null) {
            grantTypes = Arrays.asList(((String)oAuthApplicationInfo.getParameter("grant_types")).split(","));
        }
        Object parameter = oAuthApplicationInfo.getParameter("additionalProperties");
        Map additionalProperties = new HashMap();
        if (parameter instanceof String) {
            additionalProperties = (Map)new Gson().fromJson((String)parameter, Map.class);
        }
        clientInfo.setName(applicationName);
        if (!grantTypes.isEmpty()) {
            clientInfo.setGrantTypes(grantTypes);
        }
        if (StringUtils.isNotEmpty((String)callBackURL)) {
            String[] calBackUris = callBackURL.split(",");
            clientInfo.setRedirectUris(Arrays.asList(calBackUris));
        }
        if (additionalProperties.containsKey("client_id")) {
            clientInfo.setClientId((String)additionalProperties.get("client_id"));
        } else if (StringUtils.isNotEmpty((String)oAuthApplicationInfo.getClientId())) {
            clientInfo.setClientId(oAuthApplicationInfo.getClientId());
        } else {
            clientInfo.setClientId(UUID.randomUUID().toString());
        }
        if (additionalProperties.containsKey("client_secret")) {
            clientInfo.setClientId((String)additionalProperties.get("client_secret"));
        } else if (StringUtils.isNotEmpty((String)oAuthApplicationInfo.getClientSecret())) {
            clientInfo.setSecret(oAuthApplicationInfo.getClientSecret());
        } else {
            clientInfo.setSecret(UUID.randomUUID().toString());
        }
        if (additionalProperties.containsKey("bypass_approval_pages")) {
            clientInfo.setBypassApprovalPage(Boolean.parseBoolean((String)additionalProperties.get("bypass_approval_pages")));
        }
        if (additionalProperties.containsKey("restrict_response_types")) {
            clientInfo.setBypassApprovalPage(Boolean.parseBoolean((String)additionalProperties.get("bypass_approval_pages")));
        }
        clientInfo.setDescription(clientInfo.getName());
        return clientInfo;
    }

    public OAuthApplicationInfo updateApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        if (oAuthAppRequest.getOAuthApplicationInfo() != null) {
            ClientInfo clientInfo = this.fromOauthAppRequestToClientInfo(oAuthAppRequest);
            Response response = this.pingFederateDCRClient.updateApplication(this.toClientInfoList(clientInfo));
            if (response.status() == 200) {
                return this.fromClientInfoToOauthApplicationInfo(clientInfo);
            }
            throw new APIManagementException("Error while updating application. Response status code:" + response.status());
        }
        return null;
    }

    public void deleteApplication(String clientId) throws APIManagementException {
        Response response = this.pingFederateDCRClient.deleteApplication(clientId);
        if (response.status() != 200) {
            throw new APIManagementException("Error while Deleting Client Application from PingFederate Server");
        }
        log.debug((Object)("Oauth Client Related to " + clientId + " Deleted successfully from PingFederate Server"));
    }

    public OAuthApplicationInfo retrieveApplication(String clientId) throws APIManagementException {
        ClientInfo application = this.pingFederateDCRClient.getApplication(clientId);
        if (application != null) {
            return this.fromClientInfoToOauthApplicationInfo(application);
        }
        return null;
    }

    public AccessTokenInfo getNewApplicationAccessToken(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        TokenInfo tokenResponse;
        if (accessTokenRequest == null) {
            log.warn((Object)"No information available to generate Token.");
            return null;
        }
        String scopes = null;
        if (accessTokenRequest.getScope() != null) {
            scopes = String.join((CharSequence)" ", accessTokenRequest.getScope());
        }
        try {
            tokenResponse = this.authClient.generate(accessTokenRequest.getClientId(), accessTokenRequest.getClientSecret(), "client_credentials", scopes);
        }
        catch (KeyManagerClientException e) {
            throw new APIManagementException("Error occurred while calling token endpoint!", (Throwable)e);
        }
        AccessTokenInfo tokenInfo = new AccessTokenInfo();
        if (StringUtils.isNotEmpty((String)tokenResponse.getScope())) {
            tokenInfo.setScope(tokenResponse.getScope().split(" "));
        } else {
            tokenInfo.setScope(new String[0]);
        }
        tokenInfo.setAccessToken(tokenResponse.getToken());
        tokenInfo.setValidityPeriod(tokenResponse.getExpiry());
        return tokenInfo;
    }

    public String getNewApplicationConsumerSecret(AccessTokenRequest accessTokenRequest) throws APIManagementException {
        ClientInfo application = this.pingFederateDCRClient.getApplication(accessTokenRequest.getClientId());
        application.setSecret(UUID.randomUUID().toString());
        application.setForceSecretChange(true);
        this.pingFederateDCRClient.updateApplication(this.toClientInfoList(application));
        return null;
    }

    public AccessTokenInfo getTokenMetaData(String accessToken) throws APIManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Getting access token metadata from authorization server. Access token %s", accessToken));
        }
        AccessTokenInfo tokenInfo = new AccessTokenInfo();
        IntrospectInfo introspectInfo = this.introspectionClient.introspect(accessToken);
        tokenInfo.setTokenValid(introspectInfo.isActive());
        if (tokenInfo.isTokenValid()) {
            long expiryTime = introspectInfo.getExpiry();
            tokenInfo.addParameter("exp", (Object)expiryTime);
            if (StringUtils.isNotEmpty((String)introspectInfo.getScope())) {
                tokenInfo.setScope(introspectInfo.getScope().split("\\s+"));
            }
            tokenInfo.setConsumerKey(introspectInfo.getClientId());
            tokenInfo.setEndUserName(introspectInfo.getUsername());
            return tokenInfo;
        }
        return null;
    }

    public KeyManagerConfiguration getKeyManagerConfiguration() throws APIManagementException {
        return this.configuration;
    }

    public OAuthApplicationInfo mapOAuthApplication(OAuthAppRequest oAuthAppRequest) throws APIManagementException {
        ClientInfo application;
        OAuthApplicationInfo oAuthApplicationInfo = oAuthAppRequest.getOAuthApplicationInfo();
        if (oAuthApplicationInfo != null && (application = this.pingFederateDCRClient.getApplication(oAuthAppRequest.getOAuthApplicationInfo().getClientId())) != null) {
            return this.fromClientInfoToOauthApplicationInfo(application);
        }
        return null;
    }

    public void loadConfiguration(KeyManagerConfiguration keyManagerConfiguration) throws APIManagementException {
        this.configuration = keyManagerConfiguration;
        String clientRegistrationEndpoint = (String)this.configuration.getParameter("client_registration_endpoint");
        String introspectionEndpoint = (String)this.configuration.getParameter("introspection_endpoint");
        String username = (String)this.configuration.getParameter("username");
        String password = (String)this.configuration.getParameter("password");
        String clientId = (String)this.configuration.getParameter("client_id");
        String clientSecret = (String)this.configuration.getParameter("client_secret");
        String tokenEndpoint = (String)this.configuration.getParameter("token_endpoint");
        if (StringUtils.isNotEmpty((String)clientRegistrationEndpoint) && StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
            this.pingFederateDCRClient = (PingFederateDCRClient)Feign.builder().client((Client)new ApacheFeignHttpClient(APIUtil.getHttpClient((String)clientRegistrationEndpoint))).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(username, password)).target(PingFederateDCRClient.class, clientRegistrationEndpoint);
        }
        if (StringUtils.isNotEmpty((String)introspectionEndpoint) && StringUtils.isNotEmpty((String)clientId) && StringUtils.isNotEmpty((String)clientSecret)) {
            this.introspectionClient = (IntrospectClient)Feign.builder().client((Client)new ApacheFeignHttpClient(APIUtil.getHttpClient((String)introspectionEndpoint))).encoder((Encoder)new FormEncoder()).decoder((Decoder)new GsonDecoder()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(clientId, clientSecret)).target(IntrospectClient.class, introspectionEndpoint);
        }
        if (StringUtils.isNotEmpty((String)tokenEndpoint)) {
            this.authClient = (AuthClient)Feign.builder().client((Client)new ApacheFeignHttpClient(APIUtil.getHttpClient((String)tokenEndpoint))).encoder((Encoder)new GsonEncoder()).decoder((Decoder)new GsonDecoder()).logger((Logger)new Slf4jLogger()).errorDecoder((ErrorDecoder)new KMClientErrorDecoder()).encoder((Encoder)new FormEncoder()).target(AuthClient.class, tokenEndpoint);
        }
    }

    public boolean registerNewResource(API api, Map map) throws APIManagementException {
        return false;
    }

    public Map getResourceByApiId(String s) throws APIManagementException {
        return null;
    }

    public boolean updateRegisteredResource(API api, Map map) throws APIManagementException {
        return false;
    }

    public void deleteRegisteredResourceByAPIId(String s) throws APIManagementException {
    }

    public void deleteMappedApplication(String s) throws APIManagementException {
    }

    public Set<String> getActiveTokensByConsumerKey(String s) throws APIManagementException {
        return null;
    }

    public AccessTokenInfo getAccessTokenByConsumerKey(String s) throws APIManagementException {
        return null;
    }

    public Map<String, Set<Scope>> getScopesForAPIS(String s) throws APIManagementException {
        return null;
    }

    public void registerScope(Scope scope) throws APIManagementException {
    }

    public Scope getScopeByName(String s) throws APIManagementException {
        return null;
    }

    public Map<String, Scope> getAllScopes() throws APIManagementException {
        return null;
    }

    public void deleteScope(String s) throws APIManagementException {
    }

    public void updateScope(Scope scope) throws APIManagementException {
    }

    public boolean isScopeExists(String s) throws APIManagementException {
        return false;
    }

    public String getType() {
        return "PingFederate";
    }
}

