/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.pingfederate.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.apimgt.api.model.ConfigurationDto;
import org.wso2.carbon.apimgt.api.model.KeyManagerConnectorConfiguration;
import org.wso2.pingfederate.client.PingFederatKeyManagerClient;
import org.wso2.pingfederate.client.PingFederateJWTValidatorImpl;

@Component(name="pingfederate.configuration.component", immediate=true, service={KeyManagerConnectorConfiguration.class})
public class PingFederateConnectorConfiguration
implements KeyManagerConnectorConfiguration {
    public String getImplementation() {
        return PingFederatKeyManagerClient.class.getName();
    }

    public String getJWTValidator() {
        return PingFederateJWTValidatorImpl.class.getName();
    }

    public List<ConfigurationDto> getConnectionConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("username", "Username", "input", "Username of admin user", "", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("password", "Password", "input", "Password of Admin user", "", true, true, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("client_id", "Client ID", "input", "Client Id for Token Validation", "", true, false, Collections.emptyList(), false));
        configurationDtoList.add(new ConfigurationDto("client_secret", "Client Secret", "input", "Client Secret for Token Validation", "", true, true, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public List<ConfigurationDto> getApplicationConfigurations() {
        ArrayList<ConfigurationDto> configurationDtoList = new ArrayList<ConfigurationDto>();
        configurationDtoList.add(new ConfigurationDto("bypassApprovalPage", "Bypass Approval Pages", "select", "Enable to skip authorization approval pages", "false", false, false, Arrays.asList("false", "true"), false));
        configurationDtoList.add(new ConfigurationDto("restrictedResponseTypes", "Restricted Response Types", "select", "Select Response Types Client can request", "", false, false, Arrays.asList("code", "token", "id_token", "code token", "code id_token", "token id_token", "code token id_token"), true));
        configurationDtoList.add(new ConfigurationDto("clientAuthnType", "Client Authentication Type", "select", "Select the OAuth Client Authentication Type", "SECRET", false, false, Arrays.asList("NONE", "SECRET"), false));
        configurationDtoList.add(new ConfigurationDto("restrictedScopes", "Restricted Scopes", "input", "Add available scopes that the client can request", "", false, false, Collections.emptyList(), false));
        return configurationDtoList;
    }

    public String getType() {
        return "PingFederate";
    }

    public String getDisplayName() {
        return "PingFederate";
    }

    public String getDefaultConsumerKeyClaim() {
        return "client_id_name";
    }
}

