/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.api.model.OAuthAppRequest;
import org.wso2.carbon.apimgt.api.model.OAuthApplicationInfo;
import org.wso2.carbon.apimgt.impl.AMDefaultKeyManagerImpl;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class WSO2ISOAuthClient
extends AMDefaultKeyManagerImpl {
    private static final Log log = LogFactory.getLog(WSO2ISOAuthClient.class);
    private boolean kmAdminAsAppOwner = false;

    public String getType() {
        return "WSO2-IS";
    }

    public void loadConfiguration(KeyManagerConfiguration configuration) throws APIManagementException {
        Object kmAdminAsAppOwnerParameter = configuration.getParameter("km_admin_as_app_owner");
        if (kmAdminAsAppOwnerParameter != null) {
            this.kmAdminAsAppOwner = (Boolean)kmAdminAsAppOwnerParameter;
        }
        super.loadConfiguration(configuration);
    }

    public OAuthApplicationInfo createApplication(OAuthAppRequest oauthAppRequest) throws APIManagementException {
        if (this.kmAdminAsAppOwner) {
            this.overrideKMAdminAsAppOwnerProperties(oauthAppRequest);
        }
        return super.createApplication(oauthAppRequest);
    }

    public OAuthApplicationInfo updateApplication(OAuthAppRequest appInfoDTO) throws APIManagementException {
        if (this.kmAdminAsAppOwner) {
            this.overrideKMAdminAsAppOwnerProperties(appInfoDTO);
        }
        return super.updateApplication(appInfoDTO);
    }

    private void overrideKMAdminAsAppOwnerProperties(OAuthAppRequest oauthAppRequest) {
        String kmAdminUsername = this.getConfigurationParamValue("Username");
        OAuthApplicationInfo oAuthApplicationInfo = oauthAppRequest.getOAuthApplicationInfo();
        oAuthApplicationInfo.addParameter("username", (Object)kmAdminUsername);
        String kmAdminTenantDomain = MultitenantUtils.getTenantDomain((String)kmAdminUsername);
        this.setTenantDomain(kmAdminTenantDomain);
    }
}

