/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.identity.auth.service.handler.AuthenticationHandler;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.is.key.manager.core.handlers.ExtendedISAuthHandler;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.core.observers.ReservedUserCreationObserver;
import org.wso2.is.key.manager.core.tokenmgt.issuers.RoleBasedScopesIssuer;

@Component(name="key.manager.core.component", immediate=true)
public class KeyManagerCoreServiceComponent {
    private static final Log log = LogFactory.getLog(KeyManagerCoreServiceComponent.class);
    private static final String RESTRICT_UNASSIGNED_SCOPES = "restrict.unassigned.scopes";

    @Activate
    protected void activate(ComponentContext cxt) {
        try {
            cxt.getBundleContext().registerService(AuthenticationHandler.class, (Object)new ExtendedISAuthHandler(), null);
            ReservedUserCreationObserver reservedUserCreationObserver = new ReservedUserCreationObserver();
            cxt.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)reservedUserCreationObserver, null);
            cxt.getBundleContext().registerService(ServerStartupObserver.class.getName(), (Object)reservedUserCreationObserver, null);
            cxt.getBundleContext().registerService(ScopeValidator.class, (Object)new RoleBasedScopesIssuer(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"KeyManagerCoreService is activated");
            }
            boolean restrictUnassignedScopes = Boolean.parseBoolean(System.getProperty(RESTRICT_UNASSIGNED_SCOPES));
            ServiceReferenceHolder.setRestrictUnassignedScopes(restrictUnassignedScopes);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"KeyManagerCoreService bundle is deactivated");
        }
    }

    @Reference(name="user.realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (realmService != null && log.isDebugEnabled()) {
            log.debug((Object)"Realm service initialized");
        }
        ServiceReferenceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ServiceReferenceHolder.getInstance().setRealmService(null);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        ServiceReferenceHolder.getInstance().setRegistryService(registryService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry Service is set in the API KeyMgt bundle.");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ServiceReferenceHolder.getInstance().setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry Service is unset in the API KeyMgt bundle.");
        }
    }

    @Reference(name="tenant.registryloader", service=TenantRegistryLoader.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantRegistryLoader")
    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        ServiceReferenceHolder.getInstance().setTenantRegistryLoader(tenantRegistryLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is set in the API KeyMgt bundle.");
        }
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        ServiceReferenceHolder.getInstance().setTenantRegistryLoader(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is unset in the API KeyMgt bundle.");
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ServiceReferenceHolder.setContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        ServiceReferenceHolder.setContextService(null);
    }
}

