/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.tokenmgt.issuers;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.saml.saml2.core.Assertion;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.callback.OAuthCallback;
import org.wso2.carbon.identity.oauth.common.GrantType;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2ScopeServerException;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.bean.Scope;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.model.ResourceScopeCacheEntry;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.core.tokenmgt.issuers.AbstractScopesIssuer;
import org.wso2.is.key.manager.core.tokenmgt.util.TokenMgtUtil;

public class RoleBasedScopesIssuer
extends AbstractScopesIssuer
implements ScopeValidator {
    private static Log log = LogFactory.getLog(RoleBasedScopesIssuer.class);
    private static final String DEFAULT_SCOPE_NAME = "default";
    private static final String PRESERVED_CASE_SENSITIVE_VARIABLE = "preservedCaseSensitive";
    private static final String ACCESS_TOKEN_DO = "AccessTokenDO";
    public static final String CHECK_ROLES_FROM_SAML_ASSERTION = "checkRolesFromSamlAssertion";
    public static final String RETRIEVE_ROLES_FROM_USERSTORE_FOR_SCOPE_VALIDATION = "retrieveRolesFromUserStoreForScopeValidation";
    private static final String SCOPE_VALIDATOR_NAME = "Role based scope validator";
    private static final String OPENID = "openid";
    protected boolean rejectUnregisteredScopes = false;
    private IdentityProvider identityProvider = null;
    private static final String ISSUER_PREFIX = "default";
    OAuthServerConfiguration oAuthServerConfiguration = OAuthServerConfiguration.getInstance();
    private static final String REFRESH_TOKEN_GRANT_TYPE = "refresh_token";

    public boolean validateScope(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) throws IdentityOAuth2Exception {
        List<String> authScopes = this.getScopes(oAuthAuthzReqMessageContext);
        oAuthAuthzReqMessageContext.setApprovedScope(authScopes.toArray(new String[authScopes.size()]));
        return true;
    }

    public boolean validateScope(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) throws IdentityOAuth2Exception {
        String grantType = oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getGrantType();
        boolean isRefreshRequest = REFRESH_TOKEN_GRANT_TYPE.equals(grantType);
        boolean isFederatedUser = oAuthTokenReqMessageContext.getAuthorizedUser().isFederatedUser();
        if (isRefreshRequest && isFederatedUser) {
            return true;
        }
        List<String> authScopes = this.getScopes(oAuthTokenReqMessageContext);
        oAuthTokenReqMessageContext.setScope(authScopes.toArray(new String[authScopes.size()]));
        return true;
    }

    public boolean validateScope(OAuth2TokenValidationMessageContext oAuth2TokenValidationMessageContext) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO = (AccessTokenDO)oAuth2TokenValidationMessageContext.getProperty((Object)ACCESS_TOKEN_DO);
        if (accessTokenDO == null) {
            return false;
        }
        String resource = this.getResourceFromMessageContext(oAuth2TokenValidationMessageContext);
        if (resource == null) {
            return true;
        }
        String[] scopes = accessTokenDO.getScope();
        if (scopes == null || scopes.length == 0) {
            return true;
        }
        String resourceScope = null;
        int resourceTenantId = -1;
        boolean cacheHit = false;
        OAuthCacheKey cacheKey = new OAuthCacheKey(resource);
        CacheEntry result = (CacheEntry)OAuthCache.getInstance().getValueFromCache((Serializable)cacheKey);
        if (result != null && result instanceof ResourceScopeCacheEntry) {
            resourceScope = ((ResourceScopeCacheEntry)result).getScope();
            resourceTenantId = ((ResourceScopeCacheEntry)result).getTenantId();
            cacheHit = true;
        }
        if (!cacheHit) {
            Pair scopeMap = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().findTenantAndScopeOfResource(resource);
            if (scopeMap != null) {
                resourceScope = (String)scopeMap.getLeft();
                resourceTenantId = (Integer)scopeMap.getRight();
            }
            cacheKey = new OAuthCacheKey(resource);
            ResourceScopeCacheEntry cacheEntry = new ResourceScopeCacheEntry(resourceScope);
            cacheEntry.setTenantId(resourceTenantId);
            OAuthCache.getInstance().addToCache(cacheKey, (CacheEntry)cacheEntry);
        }
        if (resourceScope == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource '" + resource + "' is not protected with a scope"));
            }
            return true;
        }
        ArrayList<String> scopeList = new ArrayList<String>(Arrays.asList(scopes));
        if (!scopeList.contains(resourceScope)) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)("Access token '" + accessTokenDO.getAccessToken() + "' does not bear the scope '" + resourceScope + "'"));
            }
            return false;
        }
        if (accessTokenDO.getAuthzUser().isFederatedUser() && (Boolean.parseBoolean(System.getProperty(CHECK_ROLES_FROM_SAML_ASSERTION)) || !Boolean.parseBoolean(System.getProperty(RETRIEVE_ROLES_FROM_USERSTORE_FOR_SCOPE_VALIDATION)))) {
            return true;
        }
        AuthenticatedUser authenticatedUser = OAuthUtil.getAuthenticatedUser((String)oAuth2TokenValidationMessageContext.getResponseDTO().getAuthorizedUser());
        String clientId = accessTokenDO.getConsumerKey();
        List<String> requestedScopes = Arrays.asList(scopes);
        List<String> authorizedScopes = null;
        String[] userRoles = null;
        Map<String, String> appScopes = this.getAppScopes(clientId, authenticatedUser, requestedScopes);
        if (appScopes != null) {
            if (this.isAppScopesEmpty(appScopes, clientId).booleanValue()) {
                authorizedScopes = this.getAllowedScopes(requestedScopes);
                oAuth2TokenValidationMessageContext.getResponseDTO().setScope(authorizedScopes.toArray(new String[authorizedScopes.size()]));
                return true;
            }
            userRoles = this.getUserRoles(authenticatedUser, null);
            authorizedScopes = this.getAuthorizedScopes(userRoles, requestedScopes, appScopes);
            oAuth2TokenValidationMessageContext.getResponseDTO().setScope(authorizedScopes.toArray(new String[authorizedScopes.size()]));
        }
        if (ArrayUtils.isEmpty(userRoles)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No roles associated for the user " + authenticatedUser.getUserName()));
            }
            return false;
        }
        return true;
    }

    protected Set<Scope> retrieveScopes(int tenantId) throws IdentityOAuth2ScopeServerException {
        return OAuthTokenPersistenceFactory.getInstance().getOAuthScopeDAO().getScopes(tenantId, "DEFAULT");
    }

    public String getName() {
        return SCOPE_VALIDATOR_NAME;
    }

    @Override
    public String getPrefix() {
        return "default";
    }

    private String getResourceFromMessageContext(OAuth2TokenValidationMessageContext messageContext) {
        String resource = null;
        if (messageContext.getRequestDTO().getContext() != null) {
            for (OAuth2TokenValidationRequestDTO.TokenValidationContextParam resourceParam : messageContext.getRequestDTO().getContext()) {
                if (resourceParam == null || !"resource".equals(resourceParam.getKey())) continue;
                resource = resourceParam.getValue();
                break;
            }
        }
        return resource;
    }

    public List<String> getScopes(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) {
        AuthenticatedUser authenticatedUser;
        String clientId;
        Map<String, String> appScopes;
        ArrayList<String> requestedScopes = null;
        ArrayList<String> scopes = new ArrayList<String>();
        if (oAuthAuthzReqMessageContext.getApprovedScope() != null) {
            requestedScopes = new ArrayList<String>(Arrays.asList(oAuthAuthzReqMessageContext.getApprovedScope()));
            for (String scope : requestedScopes) {
                if (!this.checkForProductRestAPIScopes(scope)) continue;
                scopes.add(scope);
            }
            requestedScopes.removeAll(scopes);
            if (requestedScopes.isEmpty()) {
                return scopes;
            }
        }
        if ((appScopes = this.getAppScopes(clientId = oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getConsumerKey(), authenticatedUser = oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getUser(), requestedScopes)) != null) {
            if (this.isAppScopesEmpty(appScopes, clientId).booleanValue()) {
                List<String> authorizedScopes = this.getAllowedScopes(requestedScopes);
                scopes.addAll(authorizedScopes);
                return scopes;
            }
            String[] userRoles = this.getUserRoles(authenticatedUser, null);
            List<String> authorizedScopes = this.getAuthorizedScopes(userRoles, requestedScopes, appScopes);
            scopes.addAll(authorizedScopes);
        }
        return scopes;
    }

    @Override
    public List<String> getScopes(OAuthCallback scopeValidationCallback) {
        AuthenticatedUser authenticatedUser;
        List<String> authorizedScopes = null;
        List<String> requestedScopes = Arrays.asList(scopeValidationCallback.getRequestedScope());
        String clientId = scopeValidationCallback.getClient();
        Map<String, String> appScopes = this.getAppScopes(clientId, authenticatedUser = scopeValidationCallback.getResourceOwner(), requestedScopes);
        if (appScopes != null) {
            if (this.isAppScopesEmpty(appScopes, clientId).booleanValue()) {
                return this.getAllowedScopes(requestedScopes);
            }
            String[] userRoles = this.getUserRoles(authenticatedUser, null);
            authorizedScopes = this.getAuthorizedScopes(userRoles, requestedScopes, appScopes);
        }
        return authorizedScopes;
    }

    @Override
    public List<String> getScopes(OAuthTokenReqMessageContext tokReqMsgCtx) {
        ArrayList<String> scopes = new ArrayList<String>();
        ArrayList<String> requestedScopes = new ArrayList<String>(Arrays.asList(tokReqMsgCtx.getScope()));
        for (String scope : requestedScopes) {
            if (!this.checkForProductRestAPIScopes(scope)) continue;
            scopes.add(scope);
        }
        requestedScopes.removeAll(scopes);
        String clientId = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getClientId();
        AuthenticatedUser authenticatedUser = tokReqMsgCtx.getAuthorizedUser();
        if (requestedScopes.isEmpty()) {
            return scopes;
        }
        Map<String, String> appScopes = this.getAppScopes(clientId, authenticatedUser, requestedScopes);
        if (appScopes != null) {
            String[] userRoles = new String[]{};
            if (this.isAppScopesEmpty(appScopes, clientId).booleanValue()) {
                List<String> authorizedScopes = this.getAuthorizedScopes(userRoles, requestedScopes, appScopes);
                scopes.addAll(authorizedScopes);
                return scopes;
            }
            String grantType = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType();
            String isSAML2Enabled = System.getProperty(CHECK_ROLES_FROM_SAML_ASSERTION);
            String isRetrieveRolesFromUserStoreForScopeValidation = System.getProperty(RETRIEVE_ROLES_FROM_USERSTORE_FOR_SCOPE_VALIDATION);
            if (GrantType.SAML20_BEARER.toString().equals(grantType) && Boolean.parseBoolean(isSAML2Enabled)) {
                authenticatedUser.setUserStoreDomain("FEDERATED");
                tokReqMsgCtx.setAuthorizedUser(authenticatedUser);
                Assertion assertion = (Assertion)tokReqMsgCtx.getProperty((Object)"SAML2Assertion");
                userRoles = this.getRolesFromAssertion(assertion);
            } else if ("urn:ietf:params:oauth:grant-type:jwt-bearer".equals(grantType) && !Boolean.parseBoolean(isRetrieveRolesFromUserStoreForScopeValidation)) {
                this.configureForJWTGrant(tokReqMsgCtx);
                Map userAttributes = authenticatedUser.getUserAttributes();
                if (tokReqMsgCtx.getProperty((Object)"ROLE_CLAIM") != null) {
                    userRoles = this.getRolesFromUserAttribute(userAttributes, tokReqMsgCtx.getProperty((Object)"ROLE_CLAIM").toString());
                }
            } else {
                if (authenticatedUser.isFederatedUser() && StringUtils.equals((String)REFRESH_TOKEN_GRANT_TYPE, (String)grantType)) {
                    try {
                        authenticatedUser.setUserName(OAuth2Util.getAppInformationByClientId((String)clientId).getAppOwner().getUserName());
                    }
                    catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
                        log.error((Object)("Error when retrieving the username " + e.getMessage()), e);
                    }
                }
                userRoles = this.getUserRoles(authenticatedUser, grantType);
            }
            List<String> authorizedScopes = this.getAuthorizedScopes(userRoles, requestedScopes, appScopes);
            scopes.addAll(authorizedScopes);
        }
        return scopes;
    }

    private boolean checkForProductRestAPIScopes(String scope) {
        return scope.startsWith("apim:") || scope.startsWith("apim_analytics:") || scope.startsWith("service_catalog:");
    }

    private String[] getUserRoles(AuthenticatedUser authenticatedUser, String grantType) {
        String username;
        String tenantDomain;
        String[] userRoles = null;
        if (authenticatedUser.isFederatedUser() && StringUtils.equals((String)REFRESH_TOKEN_GRANT_TYPE, (String)grantType) || !authenticatedUser.isFederatedUser()) {
            tenantDomain = authenticatedUser.getTenantDomain();
            username = authenticatedUser.getUserName();
        } else {
            tenantDomain = MultitenantUtils.getTenantDomain((String)authenticatedUser.getAuthenticatedSubjectIdentifier());
            username = MultitenantUtils.getTenantAwareUsername((String)authenticatedUser.getAuthenticatedSubjectIdentifier());
        }
        String userStoreDomain = authenticatedUser.getUserStoreDomain();
        RealmService realmService = this.getRealmService();
        try {
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            if (tenantId == 0 || tenantId == -1) {
                tenantId = this.getTenantIdOfUser(username);
            }
            UserStoreManager userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            String endUsernameWithDomain = this.addDomainToName(username, userStoreDomain);
            userRoles = userStoreManager.getRoleListOfUser(endUsernameWithDomain);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error when getting the tenant's UserStoreManager or when getting roles of user ", (Throwable)e);
        }
        return userRoles;
    }

    private List<String> getAuthorizedScopes(String[] userRoles, List<String> requestedScopes, Map<String, String> appScopes) {
        List<String> userRoleList;
        ArrayList<String> defaultScope = new ArrayList<String>();
        defaultScope.add("default");
        if (userRoles == null || userRoles.length == 0) {
            userRoles = new String[]{};
        }
        ArrayList<String> authorizedScopes = new ArrayList<String>();
        String preservedCaseSensitiveValue = System.getProperty(PRESERVED_CASE_SENSITIVE_VARIABLE);
        boolean preservedCaseSensitive = JavaUtils.isTrueExplicitly((String)preservedCaseSensitiveValue);
        if (preservedCaseSensitive) {
            userRoleList = Arrays.asList(userRoles);
        } else {
            userRoleList = new ArrayList<String>();
            for (String aRole : userRoles) {
                userRoleList.add(aRole.toLowerCase(Locale.ENGLISH));
            }
        }
        for (String scope : requestedScopes) {
            boolean isRestrictUnassignedScopes = ServiceReferenceHolder.isRestrictUnassignedScopes();
            if ((!isRestrictUnassignedScopes || !this.oAuthServerConfiguration.getAllowedScopes().contains(scope)) && !appScopes.containsKey(scope) && isRestrictUnassignedScopes) continue;
            this.addAuthorizedRoles(appScopes, scope, preservedCaseSensitive, userRoleList, authorizedScopes);
        }
        return !authorizedScopes.isEmpty() ? authorizedScopes : defaultScope;
    }

    private List<String> addAuthorizedRoles(Map<String, String> appScopes, String scope, boolean preservedCaseSensitive, List<String> userRoleList, List<String> authorizedScopes) {
        String roles = appScopes.get(scope);
        if (roles != null && roles.length() != 0) {
            ArrayList<String> roleList = new ArrayList<String>();
            for (String aRole : roles.split(",")) {
                if (preservedCaseSensitive) {
                    roleList.add(aRole.trim());
                    continue;
                }
                roleList.add(aRole.trim().toLowerCase(Locale.ENGLISH));
            }
            roleList.retainAll(userRoleList);
            if (!roleList.isEmpty()) {
                authorizedScopes.add(scope);
            }
        } else {
            authorizedScopes.add(scope);
        }
        return authorizedScopes;
    }

    private String[] getRolesFromUserAttribute(Map<ClaimMapping, String> userAttributes, String roleClaim) {
        for (Map.Entry<ClaimMapping, String> entry : userAttributes.entrySet()) {
            if (null == entry.getKey().getLocalClaim() || !roleClaim.equals(entry.getKey().getLocalClaim().getClaimUri()) || !StringUtils.isNotBlank((String)entry.getValue())) continue;
            return entry.getValue().replace("\\/", "/").replace("[", "").replace("]", "").replace("\"", "").split(FrameworkUtils.getMultiAttributeSeparator());
        }
        return new String[0];
    }

    protected String addDomainToName(String username, String domainName) {
        return UserCoreUtil.addDomainToName((String)username, (String)domainName);
    }

    protected String[] getRolesFromAssertion(Assertion assertion) {
        return TokenMgtUtil.getRolesFromAssertion(assertion);
    }

    protected void configureForJWTGrant(OAuthTokenReqMessageContext tokReqMsgCtx) {
        SignedJWT signedJWT = null;
        JWTClaimsSet claimsSet = null;
        String[] roles = null;
        try {
            signedJWT = this.getSignedJWT(tokReqMsgCtx);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Couldn't retrieve signed JWT", (Throwable)e);
        }
        if (signedJWT != null) {
            claimsSet = this.getClaimSet(signedJWT);
        }
        String jwtIssuer = claimsSet != null ? claimsSet.getIssuer() : null;
        String tenantDomain = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
        try {
            this.identityProvider = IdentityProviderManager.getInstance().getIdPByMetadataProperty("idpIssuerName", jwtIssuer, tenantDomain, false);
            if (this.identityProvider == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IDP not found when retrieving for IDP using property: idpIssuerName with value: " + jwtIssuer + ". Attempting to retrieve IDP using IDP Name as issuer."));
                }
                this.identityProvider = IdentityProviderManager.getInstance().getIdPByName(jwtIssuer, tenantDomain);
            }
            if (this.identityProvider != null) {
                if (StringUtils.equalsIgnoreCase((String)this.identityProvider.getIdentityProviderName(), (String)"default")) {
                    this.identityProvider = this.getResidentIDPForIssuer(tenantDomain, jwtIssuer);
                    if (this.identityProvider == null) {
                        log.error((Object)("No Registered IDP found for the JWT with issuer name : " + jwtIssuer));
                    }
                }
            } else {
                log.error((Object)("No Registered IDP found for the JWT with issuer name : " + jwtIssuer));
            }
        }
        catch (IdentityOAuth2Exception | IdentityProviderManagementException e) {
            log.error((Object)"Couldn't initiate identity provider instance", e);
        }
        try {
            roles = claimsSet != null ? claimsSet.getStringArrayClaim(this.identityProvider.getClaimConfig().getRoleClaimURI()) : null;
        }
        catch (ParseException e) {
            log.error((Object)"Couldn't retrieve roles:", (Throwable)e);
        }
        ArrayList<String> updatedRoles = new ArrayList<String>();
        if (roles != null) {
            for (String role : roles) {
                String updatedRoleClaimValue = this.getUpdatedRoleClaimValue(this.identityProvider, role);
                if (updatedRoleClaimValue != null) {
                    updatedRoles.add(updatedRoleClaimValue);
                    continue;
                }
                updatedRoles.add(role);
            }
        }
        AuthenticatedUser user = tokReqMsgCtx.getAuthorizedUser();
        Map userAttributes = user.getUserAttributes();
        String roleClaim = this.identityProvider.getClaimConfig().getRoleClaimURI();
        if (roleClaim != null) {
            userAttributes.put(ClaimMapping.build((String)roleClaim, (String)roleClaim, null, (boolean)false), ((Object)updatedRoles).toString().replace(" ", ""));
            tokReqMsgCtx.addProperty((Object)"ROLE_CLAIM", (Object)roleClaim);
        }
        user.setUserAttributes(userAttributes);
        tokReqMsgCtx.setAuthorizedUser(user);
    }

    private SignedJWT getSignedJWT(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        SignedJWT signedJWT;
        RequestParameter[] params = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getRequestParameters();
        String assertion = null;
        for (RequestParameter param : params) {
            if (!param.getKey().equals("assertion")) continue;
            assertion = param.getValue()[0];
            break;
        }
        if (StringUtils.isEmpty(assertion)) {
            String errorMessage = "Error while retrieving assertion";
            throw new IdentityOAuth2Exception(errorMessage);
        }
        try {
            signedJWT = SignedJWT.parse(assertion);
            if (log.isDebugEnabled()) {
                log.debug((Object)signedJWT);
            }
        }
        catch (ParseException e) {
            String errorMessage = "Error while parsing the JWT.";
            throw new IdentityOAuth2Exception(errorMessage, (Throwable)e);
        }
        return signedJWT;
    }

    private JWTClaimsSet getClaimSet(SignedJWT signedJWT) {
        JWTClaimsSet claimsSet = null;
        try {
            claimsSet = signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            log.error((Object)"Error when trying to retrieve claimsSet from the JWT:", (Throwable)e);
        }
        return claimsSet;
    }

    private IdentityProvider getResidentIDPForIssuer(String tenantDomain, String jwtIssuer) throws IdentityOAuth2Exception {
        IdentityProvider residentIdentityProvider;
        String issuer = "";
        try {
            residentIdentityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException var7) {
            String errorMsg = String.format("Error while getting Resident Identity Provider of '%s' tenant.", tenantDomain);
            throw new IdentityOAuth2Exception(errorMsg, (Throwable)var7);
        }
        FederatedAuthenticatorConfig[] fedAuthnConfigs = residentIdentityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        if (oauthAuthenticatorConfig != null) {
            issuer = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)"IdPEntityId").getValue();
        }
        return jwtIssuer.equals(issuer) ? residentIdentityProvider : null;
    }

    private String getUpdatedRoleClaimValue(IdentityProvider identityProvider, String currentRoleClaimValue) {
        if (StringUtils.equalsIgnoreCase((String)"LOCAL", (String)identityProvider.getIdentityProviderName())) {
            return currentRoleClaimValue;
        }
        currentRoleClaimValue = currentRoleClaimValue.replace("\\/", "/").replace("[", "").replace("]", "").replace("\"", "");
        PermissionsAndRoleConfig permissionAndRoleConfig = identityProvider.getPermissionAndRoleConfig();
        if (permissionAndRoleConfig != null && org.apache.commons.lang3.ArrayUtils.isNotEmpty((Object[])permissionAndRoleConfig.getRoleMappings())) {
            String[] receivedRoles = currentRoleClaimValue.split(FrameworkUtils.getMultiAttributeSeparator());
            ArrayList<String> updatedRoleClaimValues = new ArrayList<String>();
            block0: for (String receivedRole : receivedRoles) {
                for (RoleMapping roleMapping : permissionAndRoleConfig.getRoleMappings()) {
                    if (!roleMapping.getRemoteRole().equals(receivedRole)) continue;
                    String updatedLocalRole = StringUtils.isEmpty((String)roleMapping.getLocalRole().getUserStoreId()) ? roleMapping.getLocalRole().getLocalRoleName() : roleMapping.getLocalRole().getUserStoreId() + UserCoreConstants.DOMAIN_SEPARATOR + roleMapping.getLocalRole().getLocalRoleName();
                    updatedRoleClaimValues.add(updatedLocalRole);
                    continue block0;
                }
                if (OAuthServerConfiguration.getInstance().isReturnOnlyMappedLocalRoles()) continue;
                updatedRoleClaimValues.add(receivedRole);
            }
            if (!updatedRoleClaimValues.isEmpty()) {
                return StringUtils.join(updatedRoleClaimValues, (String)FrameworkUtils.getMultiAttributeSeparator());
            }
            return null;
        }
        if (!OAuthServerConfiguration.getInstance().isReturnOnlyMappedLocalRoles()) {
            return currentRoleClaimValue;
        }
        return null;
    }
}

