/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.handlers;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.auth.service.AuthenticationContext;
import org.wso2.carbon.identity.auth.service.AuthenticationRequest;
import org.wso2.carbon.identity.auth.service.AuthenticationResult;
import org.wso2.carbon.identity.auth.service.AuthenticationStatus;
import org.wso2.carbon.identity.auth.service.exception.AuthenticationFailException;
import org.wso2.carbon.identity.auth.service.handler.impl.BasicAuthenticationHandler;
import org.wso2.carbon.identity.auth.service.util.AuthConfigurationUtil;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;

public class ExtendedISAuthHandler
extends BasicAuthenticationHandler {
    private static final Log log = LogFactory.getLog(ExtendedISAuthHandler.class);
    private static final String BASIC_AUTH_HEADER = "Basic";
    private static final String X_WSO2_TENANT_HEADER = "X-WSO2-Tenant";

    public void init(InitConfig initConfig) {
        super.init(initConfig);
    }

    public String getName() {
        return "ExtendedISAuthHandler";
    }

    public int getPriority(MessageContext messageContext) {
        return super.getPriority(messageContext) - 1;
    }

    public boolean canHandle(MessageContext messageContext) {
        boolean authHeaderMatch = AuthConfigurationUtil.isAuthHeaderMatch((MessageContext)messageContext, (String)BASIC_AUTH_HEADER);
        return authHeaderMatch && StringUtils.isNotEmpty((CharSequence)this.getHeader(messageContext, X_WSO2_TENANT_HEADER));
    }

    protected AuthenticationResult doAuthenticate(MessageContext messageContext) throws AuthenticationFailException {
        AuthenticationResult authenticationResult;
        block9: {
            authenticationResult = super.doAuthenticate(messageContext);
            if (AuthenticationStatus.SUCCESS.equals((Object)authenticationResult.getAuthenticationStatus())) {
                AuthenticationContext authenticationContext = (AuthenticationContext)messageContext;
                String tenantHeader = this.getHeader(messageContext, X_WSO2_TENANT_HEADER);
                if (authenticationContext.getUser() != null) {
                    User user = authenticationContext.getUser();
                    try {
                        RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
                        TenantManager tenantManager = realmService.getTenantManager();
                        if (!StringUtils.isNotEmpty((CharSequence)tenantHeader)) break block9;
                        if (!user.getTenantDomain().equals(tenantHeader.trim())) {
                            if ("carbon.super".equals(user.getTenantDomain())) {
                                UserRealm superTenantUserRealm = realmService.getTenantUserRealm(-1234);
                                String superAdminUserName = superTenantUserRealm.getRealmConfiguration().getAdminUserName();
                                if (!superAdminUserName.equals(user.getUserName())) {
                                    authenticationResult.setAuthenticationStatus(AuthenticationStatus.FAILED);
                                    return authenticationResult;
                                }
                                int tenantId = tenantManager.getTenantId(tenantHeader.trim());
                                Tenant tenant = tenantManager.getTenant(tenantId);
                                if (tenant != null) {
                                    if (!tenant.isActive()) {
                                        authenticationResult.setAuthenticationStatus(AuthenticationStatus.FAILED);
                                        return authenticationResult;
                                    }
                                    user.setTenantDomain(tenant.getDomain());
                                    user.setUserName(tenant.getAdminName());
                                    break block9;
                                }
                                authenticationResult.setAuthenticationStatus(AuthenticationStatus.FAILED);
                                return authenticationResult;
                            }
                            authenticationResult.setAuthenticationStatus(AuthenticationStatus.FAILED);
                            return authenticationResult;
                        }
                        return authenticationResult;
                    }
                    catch (UserStoreException e) {
                        String errorMessage = "Error occurred while trying to authenticate. " + e.getMessage();
                        log.error((Object)errorMessage);
                        throw new AuthenticationFailException(errorMessage);
                    }
                }
            }
        }
        return authenticationResult;
    }

    private String getHeader(MessageContext messageContext, String header) {
        AuthenticationContext authenticationContext;
        if (messageContext instanceof AuthenticationContext && (authenticationContext = (AuthenticationContext)messageContext).getAuthenticationRequest() != null) {
            AuthenticationRequest authenticationRequest = authenticationContext.getAuthenticationRequest();
            return authenticationRequest.getHeader(header);
        }
        return null;
    }
}

