/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.tokenmgt.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSAnyImpl;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.identity.oauth2.OAuth2ScopeService;
import org.wso2.is.key.manager.core.internal.ServiceReferenceHolder;

public class TokenMgtUtil {
    private static final Log log = LogFactory.getLog(TokenMgtUtil.class);
    private static final String AUTHENTICATOR_NAME = "SAML2SSOAuthenticator";

    public static String[] getRolesFromAssertion(Assertion assertion) {
        ArrayList<String> roles = new ArrayList<String>();
        String roleClaim = TokenMgtUtil.getRoleClaim();
        List attributeStatementList = assertion.getAttributeStatements();
        if (attributeStatementList != null) {
            for (AttributeStatement statement : attributeStatementList) {
                List attributesList = statement.getAttributes();
                for (Attribute attribute : attributesList) {
                    String attributeName = attribute.getName();
                    if (attributeName == null || !roleClaim.equals(attributeName)) continue;
                    List attributeValues = attribute.getAttributeValues();
                    if (attributeValues != null && attributeValues.size() == 1) {
                        String attributeValueString = TokenMgtUtil.getAttributeValue((XMLObject)attributeValues.get(0));
                        String multiAttributeSeparator = TokenMgtUtil.getAttributeSeparator();
                        Object[] attributeValuesArray = attributeValueString.split(multiAttributeSeparator);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding attributes for Assertion: " + assertion + " AttributeName : " + attributeName + ", AttributeValue : " + Arrays.toString(attributeValuesArray)));
                        }
                        roles.addAll(Arrays.asList(attributeValuesArray));
                        continue;
                    }
                    if (attributeValues == null || attributeValues.size() <= 1) continue;
                    for (XMLObject attributeValue : attributeValues) {
                        String attributeValueString = TokenMgtUtil.getAttributeValue(attributeValue);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding attributes for Assertion: " + assertion + " AttributeName : " + attributeName + ", AttributeValue : " + attributeValue));
                        }
                        roles.add(attributeValueString);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Role list found for assertion: " + assertion + ", roles: " + roles));
        }
        return roles.toArray(new String[roles.size()]);
    }

    private static String getAttributeValue(XMLObject attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof XSString) {
            return TokenMgtUtil.getStringAttributeValue((XSString)attributeValue);
        }
        if (attributeValue instanceof XSAnyImpl) {
            return TokenMgtUtil.getAnyAttributeValue((XSAnyImpl)attributeValue);
        }
        return attributeValue.toString();
    }

    private static String getStringAttributeValue(XSString attributeValue) {
        return attributeValue.getValue();
    }

    private static String getAnyAttributeValue(XSAnyImpl attributeValue) {
        return attributeValue.getTextContent();
    }

    private static String getAttributeSeparator() {
        Map configParameters;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (configParameters = authenticatorConfig.getParameters()).containsKey("AttributeValueSeparator")) {
            return (String)configParameters.get("AttributeValueSeparator");
        }
        return ",";
    }

    private static String getRoleClaim() {
        Map configParameters;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (configParameters = authenticatorConfig.getParameters()).containsKey("RoleClaimAttribute")) {
            return (String)configParameters.get("RoleClaimAttribute");
        }
        return "http://wso2.org/claims/role";
    }

    public static OAuth2ScopeService getOAuth2ScopeService() {
        return (OAuth2ScopeService)PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(OAuth2ScopeService.class, null);
    }

    public static void loadTenantConfigBlockingMode(String tenantDomain) {
        try {
            ConfigurationContext ctx = ServiceReferenceHolder.getContextService().getServerConfigContext();
            TenantAxisUtils.getTenantAxisConfiguration((String)tenantDomain, (ConfigurationContext)ctx);
        }
        catch (Exception e) {
            log.error((Object)("Error while creating axis configuration for tenant " + tenantDomain), (Throwable)e);
        }
    }
}

