/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.core.handlers;

import javax.cache.Cache;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.is.key.manager.core.tokenmgt.util.CacheProvider;

public class TenantConfigMediaTypeHandler
extends Handler {
    public void put(RequestContext requestContext) {
        this.clearConfigCache();
    }

    public void delete(RequestContext requestContext) {
        this.clearConfigCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearConfigCache() {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String cacheKey = tenantId + "_" + "tenantConfigCache";
        boolean tenantFlowStarted = false;
        if (!"carbon.super".equals(tenantDomain)) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                tenantFlowStarted = true;
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                this.clearExtensionsManagerCaches(cacheKey, tenantDomain);
            }
            finally {
                if (tenantFlowStarted) {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
        } else {
            this.clearExtensionsManagerCaches(cacheKey, tenantDomain);
        }
    }

    private void clearExtensionsManagerCaches(String cacheKey, String tenantDomain) {
        CacheProvider.getInstance();
        Cache tenantConfigCache = CacheProvider.getTenantConfigCache();
        tenantConfigCache.remove((Object)cacheKey);
        CacheProvider.getInstance();
        Cache restApiScopesCache = CacheProvider.getRESTAPIScopeCache();
        restApiScopesCache.remove((Object)tenantDomain);
    }
}

